function dmag,mt,dm,m1=m1,m2=m2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute m1 and m2 from the total magnitude and the magnitude difference.
; Magnitudes (of any kind, absolute or differential) with value +100 are
; considered as unknown.
;
ft=fltarr(n_elements(mt))
index=where(mt ne +100,count)
if count gt 0 then ft[index]=10.^(-mt[index]/2.5)
;
dm_pos=dm
; Swap sign if secondary is brighter than primary
index_neg=where(dm lt 0,n_neg)
if n_neg gt 0 then dm_pos[index_neg]=-dm_pos[index_neg]
exponent=-(dm_pos<50)/2.5
fr=10.^exponent
;
mc1=fltarr(n_elements(mt))+100	; value of +100 considered unknown
mc2=fltarr(n_elements(mt))+100
j=where(fr ne 10^(-50./2.5) and mt ne +100,count)
if count gt 0 then begin
	f2=(ft[j]*fr[j])/(1+fr[j])
	f1=f2/fr[j]
	mc1[j]=-2.5*alog10(f1)
	mc2[j]=-2.5*alog10(f2)
endif else begin
	mc1=mt
	mc2[*]=100
endelse
;
; Swap values if secondary is brighter than primary
if n_neg gt 0 then begin
	mc1_temp=mc1[index_neg]
	mc2_temp=mc2[index_neg]
	mc1[index_neg]=mc2_temp
	mc2[index_neg]=mc1_temp
endif
;
if keyword_set(m1) then return,mc1
if keyword_set(m2) then return,mc2
;
return,transpose([[mc1],[mc2]])
;
end
