function dms,x_in,wds=wds,gaia=gaia,aspro=aspro,simbad=simbad,dec=dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return formatted string for x in degrees. x may be array.
; Degrees can run -360 to 360.
;
if n_elements(wds) eq 0 then wds=0
if n_elements(gaia) eq 0 then gaia=0
if n_elements(aspro) eq 0 then aspro=0
if n_elements(simbad) eq 0 then simbad=0
if n_elements(dec) eq 0 then dec=0
;
x=x_in
index=where(x lt 0,count)
vorz=strarr(n_elements(x)) & vorz[*]='+'
if count gt 0 then vorz[index]='-'
x=abs(x)
deg=fix(x)
mit=fix((x-deg)*60)
sec=double(((x-deg)*60-mit)*60)
index=where(sec eq 60.0,count)
if count gt 0 then begin
	mit[index]=mit[index]+1
	sec[index]=0.0
endif
if wds then begin
label= strcompress(vorz+string(deg,format='(i2.2)')) $
      +strcompress(string(nint(mit+sec/60),format='(i2.2)'))
endif else if gaia then begin
label= strcompress(vorz+string(deg,format='(i2.2)'))+' ' $
      +strcompress(string(mit,format='(i2.2)'))+' ' $
      +strcompress(string(sec,format='(f7.4)'))
endif else if aspro then begin
label= vorz+string(deg,format='(i2.2)')+':' $
      +strcompress(string(mit,format='(i2.2)'))+":" $
      +strcompress(string(fix(sec),format='(i2.2)'))+"." $
      +strcompress(string((sec-fix(sec))*1000,format='(i3.3)'))
endif else if simbad then begin
label= strcompress(vorz+string(deg,format='(i2.2)'))+' ' $
      +strcompress(string(mit,format='(i2.2)'))+' ' $
      +strcompress(string(sec,format='(f7.4)'))
endif else if dec then begin
label= strcompress(vorz+string(deg,format='(i2.2)'))+'d ' $
      +strcompress(string(mit,format='(i2.2)'))+"' " $
      +strcompress(string(sec,format='(f6.3)'))+'"'
endif else begin
label= strcompress(vorz+string(deg,format='(i3.3)'))+'d ' $
      +strcompress(string(mit,format='(i2.2)'))+"' " $
      +strcompress(string(sec,format='(f6.3)'))+'"'
endelse
if n_elements(label) eq 1 then return,label[0] else return,label
;
end
