function dms2d,d_in,sb9=sb9
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return floating point angle in degrees from sdd:mm:ss.sss input. Arrays OK.
;
if n_elements(sb9) eq 0 then sb9=0
;
d=d_in
d=strtrim(d_in,2)
index=where(strlen(d) eq 0,count)
if count gt 0 then d[index]='+00:00:00.000'
ipos=strpos(d,'.')
index=where(ipos eq -1,count)
if count gt 0 and not sb9 then d[index]=d[index]+'.0'
ipos=strpos(d,'.')
index=where(ipos eq 8,count)
if count gt 0 then d[index]='+'+d[index]
a=abs(double(strmid(d,0,3)))
if sb9 then begin
	a=a+double(strmid(d,3,2))/60
	a=a+double('0.'+strmid(d,5))/36
endif else begin
	a=a+double(strmid(d,4,2))/60
	a=a+double(strmid(d,7,9))/3600	; consider maximum 9 significant figures
endelse
index=where(strmid(d,0,1) eq '-',count)
if count gt 0 then a[index]=-a[index]
return,a
;
end
