pro edit_cri,request,i1,i2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Used to update crossindex table.
;
;
if n_params() ne 3 then begin
	print,'***Error(EDIT_CRI): wrong number of parameters!'
	print,'***Should be: request,i1,i2.'
	return
endif
;
i1=long(i1)
i2=long(i2)
;
if criparse(request,cat_1,cat_2) ne -1 then begin
	file=!catalogs_dir+'crossindex/'+cat_1+'_'+cat_2+'.cri'
        result=file_search(file,count=fcount)
        if fcount ne 0 then restore,filename=file else begin
		print,'***Error(EDIT_CRI): file not found: ',file,'!'
		return
	endelse
endif else return
;
id1=t.id1
id2=t.id2
;
index=where(id1 eq i1,count)
if count eq 1 then begin
	id2[index]=i2
endif else if count eq 0 then begin
	id1n=[id1,i1] & id2n=[id2,i2]
	s=sort(id1n)
	id1=id1n[s] & id2=id2n[s]
endif else begin
	print,'***Error(EDIT_CRI): crossindex corrupt; not saved!'
	return
endelse
;
create_cri,request,id1,id2
;
print,'Updated crossindex; number of entries=',n_elements(t)
;
end
