pro edit_startable,starid
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display widget for updating individual fields for specified
; star. If new, then add this star and display widget.
;
common StarBase,StarTable,Notes
;
print,'Modify cell contents and click OK to save, else Cancel'
print,'Important: Star ID and catalog ID must agree!'
;
if n_elements(starid) eq 0 and n_elements(startable) eq 1 then begin
	starid=startable[0].starid
endif else begin
	add_startable,starid	; Will create or add star to startable
endelse
index=where(startable.starid eq starid,count)
;
t=startable[index]
t=t[0]
;
desc=strarr(n_tags(t)+3)
desc=strarr(100)
desc[0]='0,LABEL,Startable['+string(index[0],format='(i4)')+'],CENTER'
desc[1]='1,BASE,,ROW,FRAME'
fields=tag_names(t)
k=2
imod=16
for i=0,n_tags(t)-1 do begin
	depth=string(0,format='(i1.1)')
	result=size(t.(i))
	case result[n_elements(result)-2] of
		2:item='INTEGER'
		3:item='INTEGER'
		4:item='FLOAT'
		5:item='FLOAT'
		7:item='TEXT'
	endcase
	if n_elements(t.(i)) eq 1 then begin
	if i mod imod eq 0 then begin
		desc[k]='1,BASE,,COLUMN,FRAME'
		k=k+1
		desc[k]='0,'+item+','+string(t.(i))+ $
			',LABEL_LEFT='+fields[i]+',WIDTH=12,TAG='+fields[i]
		k=k+1
	endif else begin
		if (i+1) mod imod eq 0 then depth=string(2,format='(i1.1)')
		desc[k]=depth+','+item+','+string(t.(i))+ $
			',LABEL_LEFT='+fields[i]+',WIDTH=12,TAG='+fields[i]
		k=k+1
	endelse
	endif
endfor
desc[k]='1,base,,row'
k=k+1
desc[k]='0,button,OK,QUIT,tag=OK'
k=k+1
desc[k]='2,BUTTON,Cancel,QUIT'
desc=desc[0:k]
;
t=CW_FORM(desc,/column)
;
if t.ok then begin
	k=0
	for i=0,n_tags(startable)-1 do begin
	if n_elements(startable[index[0]].(i)) eq 1 then begin
		startable[index].(i)=t[0].(k)
		k=k+1
	endif
	endfor
endif
;
end
