pro editcal,reason,command
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Remove calibration entries specified through reason parameter.
;
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
;
if n_params() ne 2 then begin
	print,'***Error(CALEDIT): you have to specify reason and command!'
	return
endif
if n_elements(reason) eq 0 then begin
	print,'***Error(CALEDIT): no reason specified!'
	return
endif
if n_elements(command) eq 0 then begin
	print,'***Error(CALEDIT): no command specified!'
	return
endif
;
if strupcase(command) eq 'UNDO' then calibrate,reason,1
;
index=where(cal_entries.reason ne reason[0],count)
if count gt 0 then begin
	set_calentries,cal_entries[index]
	print,'Removed entries; reason=',strcompress(reason)
endif else print,'No entries found for reason=',reason,'.',format='(a,a,a)'
;
end
