function edlen,lambda,p,t,f
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return refractive index for air. lambda[mu], p[mb], t[C], f[mb]
; According to Edlen, ref. K.P. Birch & M.J. Downs, 1993, Metrologia, 30, 155
; Note that hPa=mb!
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_params() gt 0 and n_params() lt 4 then begin
	p=ppair(2635)		; mb
	t=12.0d0      		; C
	f=ppwv(t,35)*p/1013.	; mb
endif
;
s=1.d0/lambda
a=8343.05d0+2406294.d0/(130.d0-s^2)+15999.d0/(38.9d0-s^2)
b=3.7345d0-0.0401d0*s^2
n=a*p/96095.43d0*(1+1d-8*(0.601d0-0.00972d0*t)*p)/(1+0.003661d0*t)-f*b*1d-2
n=n*1d-6
;
return,n+1
;
end
