function edstrip,model,lamda,u,v
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return strip brightness distribution for elliptical components.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common AstroConstants,m_sun,r_sun,a_unit,s_year
;
RAD=180/pi_circle
;
n=299	; Number of strip points
;
case abs(model.type) of
	 9:	begin
		amajor=model.diameter/2
		bminor=amajor*model.ratio
		t=atan(u,v)-model.pa/RAD
		a=(amajor^2*cos(t)^2+bminor^2*sin(t)^2)/(amajor^2*bminor^2)
		b=(2*sin(t)*cos(t)*(bminor^2-amajor^2))/(amajor^2*bminor^2)
		c=(amajor^2*sin(t)^2+bminor^2*cos(t)^2)/(amajor^2*bminor^2)
		y=(findgen(n)-n/2)/n*2*sqrt(amajor^2*cos(t)^2+bminor^2*sin(t)^2)
		b=sqrt((b*y)^2-4*a*(c*y^2-1))
		strip=alloc_strip(n,y,b,t)
		end
endcase
;
return,strip
;
end
