function efftemp,lambda,flux,cf,teff,calibrate=calibrate
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return teff for each pair of (lambda,flux). Before the call,
; cf must be calibrated with a known teff (scalar) and flux @ lambda.
;
if n_elements(calibrate) eq 0 then calibrate=0
;
if calibrate then begin
	f=blackbody(teff,lambda)
	cf=flux/f
	return,cf
endif
;
teff=1.439d-2/(lambda*alog(1+1.191d-22/(lambda^5*flux*cf)))
;
return,teff
;
t=findgen(1000)*30+100
f=blackbody(t,lambda)*cf
df=abs(f-flux)
i=where(df eq min(df))
;
return,t[i]
;
end
