function ellipse,sma,smb,pa
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return radius of point on ellipse at position angle pa. Origin is at
; center of ellipse; radius is largest at p=0. pa in radians. a and b
; are the semi-major and minor axes.
;
a=float(sma)
b=float(smb)
p=float(pa)
;
esqr=1-(b/a)^2
return,sqrt(b^2/(1-esqr*cos(p)^2))
;
end
