function eqp,m,n
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the probability of n counts for a Poisson process with mean m.
; Input n can be an array.
;
md=double(m)
nd=double(n)
y=dblarr(n_elements(n))
for i=0,n_elements(n)-1 do begin
	p=-md/max([nd[i],1.d0])
	if p lt -40 then a=0.d0 else a=exp(p)
	case n[i] of
      0:y[i]=a
   else:begin
	y[i]=md*a
	for k=2,n[i] do y[i]=y[i]*md/double(k)*a
	end
	endcase
endfor
;
return,y
;
end
