function equatorial2geocentric,e_coord,utc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Convert equatorial to geocentric coordinates. In the geocentric
; system, the z axis is parallel to the direction of the north pole,
; the x axis is parallel to the direction of the intersection of the
; Greenwich meridian with the astronomical equator, and the y axis
; completes the right-handed coordinate system.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if n_elements(utc) eq 0 then utc=0.d0
longitude=polarmotion(utc,latitude)
;
g_coord=e_coord
;
g_coord[0,*]=cos(longitude/RAD)*e_coord[0,*] $
	    -sin(longitude/RAD)*e_coord[1,*]
g_coord[1,*]=cos(longitude/RAD)*e_coord[1,*] $
	    +sin(longitude/RAD)*e_coord[0,*]
;
return,g_coord
;
end
