function equatorial2hadec,e_coord
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Convert equatorial coordinates to hour angle (h) and declination (deg).
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
a_coord=e_coord[0:1,*]
a_coord[0,*]=atan(-e_coord[1,*],e_coord[0,*])*RAD/15
a_coord[1,*]=asin( e_coord[2,*])*RAD
;
return,a_coord
;
end
