function esoid,ra,dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return positions in ESO ID format string, i.e. +HHMMSSFFDDMMSSF,
; or -HHMMSSFFDDMMSSF, with the sign corresponding to the sign of the
; declination.
;
n=n_elements(ra)
;
rah=fix(ra)
ram=fix((ra-rah)*60)
ras=(ra-rah-ram/60.)*3600
raf=(ras-fix(ras))*100
deca=abs(dec)
decd=fix(deca)
decm=fix((deca-decd)*60)
decs=(deca-decd-decm/60.)*3600
decf=(decs-fix(decs))*10
index=where(dec lt 0,count)
wds=strarr(n)+'+' & if count gt 0 then wds[index]='-'
wds=wds+string(rah,format='(i2.2)') $
       +string(fix(ram),format='(i2.2)') $
       +string(fix(ras),format='(i2.2)') $
       +string(fix(raf),format='(i2.2)') $
       +string(abs(decd),format='(i2.2)') $
       +string(fix(decm),format='(i2.2)') $
       +string(fix(decs),format='(i2.2)') $
       +string(fix(decf),format='(i1.1)')
;
return,wds
;
end
