function esopos,id0
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given an ESO ID format string, convert to RA and DEC. May contain the OBJ
; catalog identifier.
;
; Example: OBJ-164704544550315
;
id=id0
index=where(strpos(id,'OBJ') ge 0,count)
if count gt 0 then id[index]=strmid(id[index],3,16)
;
rah=float(strmid(id,1,2))
ram=float(strmid(id,3,2))
ras=float(strmid(id,5,4))/100
decd=float(strmid(id,9,2))
decm=float(strmid(id,11,2))
decs=float(strmid(id,13,3))/10
sign=strmid(id,0,1)
f=fltarr(n_elements(id))+1
index=where(sign eq '-',count)
if count gt 0 then f[index]=-1
;
return,[[rah+ram/60+ras/3600],[f*(decd+decm/60+decs/3600)]]
;
end
