pro etrg,fitsfile
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Allow user to define irregularly shaped regions in the residual map
; and specify the effective temperature for them.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
if n_elements(fitsfile) eq 0 then begin
;
image=(rm.maps[0].map-rm.zero[0])*rm.scale[0]
imsze=size(image,/dim)
nx=imsze[0]
ny=imsze[1]
scale_factor=4
image=rebin(image,imsze*scale_factor)
;
print,'-----------------------------------------------------------------'
print,'Use Freehand tool to draw regions, starting with the LARGEST one.'
print,'Select Quit to finish and assign temperatures at command prompt.'
;
xroi,bytscl(image,top=200),roi_geometry=roigeo,regions_out=regout,/block
if n_elements(roigeo) eq 0 then return
;
;print,'Now enter Teff for each region in order of decreasing size.'
;si=reverse(sort(roigeo.area))
;roigeo=roigeo(si)
;regout=regout(si)
print,'Now enter Teff for each region starting with first one:'
etmap=fltarr(nx,ny)+5000
lgmap=fltarr(nx,ny)+4.5
nr=n_elements(regout)
for ireg=0,nr-1 do begin
	read,teff, $
	prompt='Please enter Teff for region ' $
		+string(ireg+1,format='(i1)')+': '
	regout[ireg]->scale,fltarr(2)+1./float(scale_factor)
;	Make sure there are no pixels without initialization
; 	The following command is not compiled by GDL
	mask=regout[ireg]->computemask(dimension=[nx,ny])
	etmap[where(mask eq 255)]=teff
endfor
;
; Save to disk
ext_header=["XTENSION= 'IMAGE' / IMAGE extension", $
	    "BITPIX  = -32 /  Number of bits per data pixel", $
	    "NAXIS   = 2 / Number of data axes", $
	    "NAXIS1  = "+string(nx)+" /", $
	    "NAXIS2  = "+string(ny)+" /", $
	    "PCOUNT  = 0 / No Group Parameters", $
	    "GCOUNT  = 1 / One Data Group", $
	    "EXTNAME = 'Teff' /", $
	    "END     "]
fitsfile='Teff_map.fits'
writefits,fitsfile,etmap,ext_header,/append
ext_header[where(strpos(ext_header,'EXTNAME') ge 0)]="EXTNAME = 'log(g)' /"
writefits,fitsfile,lgmap,ext_header,/append
print,'Regions save to '+fitsfile+'. Click T-Map to display.'
;
endif else begin
;
etmap=mrdfits(fitsfile,1)
;
endelse
;
; Copy to CM
cm.teff=etmap
cc.teff=cm.teff
;
; (Re-)initialize the effective temperature regions
pearlinit,cm.teff
;
end
