function evalfunction,term,x,x_mid,x_scl
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
forward_function edlen,silica,amber
;
; This is the one and only function to evaluate mathematical base functions
; used for calibration and fitting of data. See create_calentries for
; initialization of function terms.
;
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if n_elements(x_mid) eq 0 then x_mid=0.0
if n_elements(x_scl) eq 0 then x_scl=1.0
;
xx=(x-x_mid)*x_scl
case term of
;	Polynomial
	'1'  : 	y=xx^0
	'x'  : 	y=xx
	'x^2': 	y=xx^2
	'x^3': 	y=xx^3
	'x^4': 	y=xx^4
	'x^5': 	y=xx^5
	'x^6': 	y=xx^6
;	Legendre polynomial
        'L_0': 	y=xx^0
        'L_1': 	y=xx
        'L_2': 	y=(3*xx^2-1)/2
        'L_3': 	y=(5*xx^3-3*xx)/2
        'L_4': 	y=(35*xx^4-30*xx^2+3)/8
        'L_5': 	y=(63*xx^5-70*xx^3+15*xx)/8
        'L_6': 	y=(231*xx^6-315*xx^4+105*xx^2-5)/16
;	Phase change [deg] due to silica and air path mismatches [microns]
	'P_0':  y=x^0	; This term only necessary if phases negative
	'P_1': 	begin
		k=360/x	; x must be wavelength[mu]
;		The refractive index of silica
		ns=silica(x)
		y=k*ns
		end
	'P_2': 	begin
		k=360/x	; x must be wavelength[mu]
;		The refractive index of air at Paranal
		na=edlen(x)
		y=k*na
		end
	 else: 	begin
	       	print,'***Error(EVALFUNCTION): unknown function: ',term,'!'
	       	return,-1
	       	end
endcase
return,y
;
end
