pro expandbg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Go through ScanTable and check whether every scan has a background measure.
; If not, fill in background data from an average over other scans in the same
; outputbeam and channel.
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if checkdata([1,2,3,8]) ne 0 then return
;
missing_bg_scans=intarr(n_elements(scantable))
;
for i=0,n_elements(ScanTable)-1 do begin
index=where(BGTable.ScanId eq ScanTable[i].ScanId,count)
if count gt 0 then begin
	if i eq 0 then begin
		ScanId=BGTable[index].ScanId
		Time=BGTable[index].Time
		Ra=BGTable[index].Ra
		Dec=BGTable[index].Dec
		s=bgscans[index]
	endif else begin
		ScanId=[ScanId,BGTable[index].ScanId]
		Time=[Time,BGTable[index].Time]
		Ra=[Ra,BGTable[index].Ra]
		Dec=[Dec,BGTable[index].Dec]
		s=[s,bgscans[index]]
	endelse
endif else begin
;	print,'No background scan for ScanNo:',ScanTable(i).Iscan
	missing_bg_scans[i]=ScanTable[i].Iscan
	j=where(startable.starid eq ScanTable[i].StarId,count)
	if count eq 0 then begin
		print,'***Error(EXPANDBG): star not found!'
		return
	endif
	if i eq 0 then begin
		ScanId=ScanTable[i].ScanId
		Time=ScanTable[i].StopTime
		Ra=startable[j].Ra
		Dec=startable[j].Dec
		s=bgscans[0]
		s.Time=ScanTable[i].StopTime
		s.RateErr=0
		replacebg,s
	endif else begin
		ScanId=[ScanId,ScanTable[i].ScanId]
		Time=[Time,ScanTable[i].StopTime]
		Ra=[Ra,startable[j].Ra]
		Dec=[Dec,startable[j].Dec]
		bgs=bgscans[0]
		bgs.Time=ScanTable[i].StopTime
		bgs.RateErr=0
		replacebg,bgs
		s=[s,bgs]
        endelse
endelse
endfor
;
Iscan=lindgen(n_elements(ScanId))+1
;
BGTable=build_bgtable(Iscan,ScanId,Time,Ra,Dec)
bgscans=s
index=where(missing_bg_scans ne 0,count)
if count gt 0 then begin
	print,'No background scans for ScanNo(s):'
	print,missing_bg_scans[index]
endif
print,'Background table/data expanded.'
;
end
