function extinct,za
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return extinction normalized to extinction at zenith.
; Input zenith angle is in degrees, may be array.
; From: Schlosser, Schmidt-Kaler, Milone, Chall. of Astr., p. 101
;
rad=180/!pi
secza1=1/cos(za/rad)-1
a=0.0018167
b=0.002875
c=0.000808
airmass=secza1+1-a*secza1-b*secza1^2-c*secza1^3
;
; Extinction in the visual is about 0.2 mag per airmass
k=-alog(10^(-0.2/2.5))
return,exp(-k*airmass)/exp(-k)
;
end
