function fdldelay,bl,ob,scan=scan,coeffs=coeffs
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return residual delay on baseline 'ST1-ST2', defined as fdl(ST2)-fdl(ST1).
; Correct returned delay for time stamp jitter. If keyword "scan" is false,
; return only for current range of records loaded.
; Baseline bl can be specified either as a string, or the baseline index
; in conjunction with the output beam index ob. If ob is undefined, then
; it is derived from the currently loaded output beam data.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(scan) eq 0 then scan=1 else scan=scan gt 0
;
if scan or n_elements(Raw0) eq 0 then begin
	rec0=0
	recn=n_elements(timestamp)-1
endif else begin
	rec0=raw0
	recn=rawn
endelse
;
r=size(bl) & n=n_elements(r)
if n_elements(ob) eq 0 then if n_elements(outputbeam) ne 0 then ob=outputbeam
if r[n-2] ne 7 then baseline=genconfig.baselineid[bl-1,ob-1] $
	       else baseline=strupcase(bl)
;
i1=where(genconfig.stationid eq strmid(baseline,0,3)) & i1=i1[0]
i2=where(genconfig.stationid eq strmid(baseline,4,3)) & i2=i2[0]
ibr=genconfig.refstation-1
d1=laserpos[i1,rec0:recn]+laserpos[ibr,rec0:recn]*(i1 ne ibr)
d2=laserpos[i2,rec0:recn]+laserpos[ibr,rec0:recn]*(i2 ne ibr)
y=timejitter(timestamp[rec0:recn],reform(d2-d1),genconfig.stroke[i2] $
					       -genconfig.stroke[i1])
x=double(nint(timestamp[rec0:recn]))
period=86400000
; return,perires(x,y,period)
coeffs=perifit(x,y,period,yfit)
return,y-yfit
;
end
