function fdllimits,hourangle,declination
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(hourangle) ne n_elements(declination) then begin
	print,'***Error(FDLLIMITS): ha and dec have different length!'
	return,-1
endif
num_elements=n_elements(hourangle)
if num_elements eq 0 then begin
	print,'***Error(FDLLIMITS): ha and dec undefined!'
	return,-1
endif
;
rad=180/!pi
ha=hourangle*(15/rad)
dec=declination/rad
;
su=dblarr(num_elements,3) & sv=su & sw=su
;
su[*,0]=+sin(ha)
su[*,1]=+cos(ha)
su[*,2]=+0
sv[*,0]=-sin(dec)*cos(ha)
sv[*,1]=+sin(dec)*sin(ha)
sv[*,2]=+cos(dec)
sw[*,0]=+cos(dec)*cos(ha)
sw[*,1]=-cos(dec)*sin(ha)
sw[*,2]=+sin(dec)
;
d=fltarr(num_elements,genconfig.numsid)
;
for i=0,genconfig.numsid-1 do begin
	coord=horizon2equatorial(GenConfig.StationCoord[*,i])
	d[*,i]=sw[*,0]*coord[0]+sw[*,1]*coord[1]+sw[*,2]*coord[2]-coord[3]
endfor
;
fdl_limit=system_config(system_id(systemid),'FDLLIMIT')
;
ret_index=intarr(num_elements)
for i=0,num_elements-1 do begin
	opl=d[i,*]-min(d[i,*])
	j=where(opl eq max(opl)) & j=j[0]
	fdl_limit=system_config(system_id(systemid),'FDLLIMIT', $
		stations=genconfig.stationid[j])
	if max(opl) lt fdl_limit then ret_index[i]=1
endfor
;
return,ret_index
;
end
