function filter_c,lambda,filter
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return response for a filter by name, given a wavelength [nm] vector.
;
; Remove "/" to read filter ID
words=nameparse(filter,'/')
filter=words[n_elements(words)-1]
;
case filter of
'U':    tm=johnson_u(lambda)
'B':    tm=johnson_b(lambda)
'V':    tm=johnson_v(lambda)
'R':    tm=johnson_r(lambda)
'I':    tm=johnson_i(lambda)
'J':    tm=johnson_j(lambda)
'H':    tm=johnson_h(lambda)
'K':    tm=johnson_k(lambda)
'L':    tm=johnson_lp(lambda)
'M':    tm=johnson_m(lambda)
'N':    tm=johnson_n(lambda)
'u':    tm=stroemgren_u(lambda)*atmosphere[lambda]*aluminium[lambda]^2 $
          *pm1p21[lambda]
'v':    tm=stroemgren_v(lambda)*atmosphere[lambda]*aluminium[lambda]^2 $
          *pm1p21[lambda]
'b':    tm=stroemgren_b(lambda)*atmosphere[lambda]*aluminium[lambda]^2 $
          *pm1p21[lambda]
'y':    tm=stroemgren_y(lambda)*atmosphere[lambda]*aluminium[lambda]^2 $
          *pm1p21[lambda]
'm800': tm=mark3_800(lambda)
'm550': tm=mark3_550(lambda)
'm500': tm=mark3_500(lambda)
'm450': tm=mark3_450(lambda)
'mhan': tm=mark3_han(lambda)
'mhab': tm=mark3_hab(lambda)
'm500o':tm=mark3_500o(lambda)
'Cousins:U':	tm=cousins_u(lambda)
'Cousins:V':	tm=cousins_v(lambda)
'Cousins:R':	tm=cousins_r(lambda)
'Cousins:I':	tm=cousins_i(lambda)
'Stroemgren:U': tm=stroemgren_u(lambda)*atmosphere[lambda]*aluminium[lambda]^2 $
          *pm1p21[lambda]
'Stroemgren:V': tm=stroemgren_v(lambda)*atmosphere[lambda]*aluminium[lambda]^2 $
          *pm1p21[lambda]
'Stroemgren:B': tm=stroemgren_b(lambda)*atmosphere[lambda]*aluminium[lambda]^2 $
          *pm1p21[lambda]
'Stroemgren:Y': tm=stroemgren_y(lambda)*atmosphere[lambda]*aluminium[lambda]^2 $
          *pm1p21[lambda]
; Vizier filters
'Johnson:U':    tm=johnson_u(lambda)
'Johnson:B':    tm=johnson_b(lambda)
'Johnson:V':    tm=johnson_v(lambda)
'Johnson:R':    tm=johnson_r(lambda)
'Johnson:I':    tm=johnson_i(lambda)
'Johnson:J':    tm=johnson_j(lambda)
'Johnson:H':    tm=johnson_h(lambda)
'Johnson:K':    tm=johnson_k(lambda)
'Johnson:L':    tm=johnson_lp(lambda)
'Johnson:M':    tm=johnson_m(lambda)
'Johnson:N':    tm=johnson_n(lambda)
'VISTA:Z':	tm=vista_z_full(lambda)
'VISTA:Y':	tm=vista_y_full(lambda)
'VISTA:J':	tm=vista_j_full(lambda)
'VISTA:H':	tm=vista_h_full(lambda)
'VISTA:Ks':	tm=vista_ks_full(lambda)
'2MASS:J':	tm=j_2mass(lambda)
'2MASS:H':	tm=h_2mass(lambda)
'2MASS:Ks':	tm=ks_2mass(lambda)
'SDSS:g':	tm=sloan_g(lambda)
'SDSS:i':	tm=sloan_i(lambda)
'SDSS:r':	tm=sloan_r(lambda)
'SDSS:u':	tm=sloan_u(lambda)
'SDSS:z':	tm=sloan_z(lambda)
; Missions
'HIP:Hp':	tm=hipparcos_hp(lambda)
'HIP:VT':	tm=tycho_vt(lambda)
'HIP:BT':	tm=tycho_bt(lambda)
'Gaia:G':	tm=gaia_g(lambda)
'GAIA2:G':	tm=gaia2_g(lambda)
'GAIA2:Grp':	tm=gaia2_grp(lambda)
'GAIA2:Gbp':	tm=gaia2_gbp(lambda)
'GAIA3:G':	tm=gaia3_g(lambda)
'GAIA3:Grp':	tm=gaia3_grp(lambda)
'GAIA3:Gbp':	tm=gaia3_gbp(lambda)
'GALEX:FUV':	tm=galex_fuv(lambda)
'GALEX:NUV':	tm=galex_nuv(lambda)
'AKARI:S9W':	tm=akari_s9w(lambda)
'AKARI:L18W':	tm=akari_l18w(lambda)
'AKARI:L18':	tm=akari_l18w(lambda)
'WISE:W1':	tm=wise_w1(lambda)
'WISE:W2':	tm=wise_w2(lambda)
'WISE:W3':	tm=wise_w3(lambda)
'WISE:W4':	tm=wise_w4(lambda)
'IRAS:12':	tm=iras_12(lambda)
'IRAS:25':	tm=iras_25(lambda)
'IRAS:60':	tm=iras_60(lambda)
'IRAS:100':	tm=iras_100(lambda)
'IRAC:3.6':	tm=irac_i1(lambda)
'IRAC:4.5':	tm=irac_i2(lambda)
'IRAC:5.7':	tm=irac_i3(lambda)
'IRAC:7.9':	tm=irac_i4(lambda)
'MIPS:24':	tm=mips_24(lambda)	; Spitzer/MIPS:24
'MIPS:70':	tm=mips_70(lambda)	; Spitzer/MIPS:70
'MIPS:160':	tm=mips_160(lambda)	; Spitzer/MIPS:160
'PACS:blue':	tm=pacs_blue(lambda)	; Herschel/PACS.blue
'PACS:green':	tm=pacs_green(lambda)	; Herschel/PACS.green
'PACS:red':	tm=pacs_red(lambda)	; Herschel/PACS.red
'PAN-STARRS:g':	tm=pans_g(lambda)
'PAN-STARRS:r':	tm=pans_r(lambda)
'PAN-STARRS:w':	tm=pans_w(lambda)
'PAN-STARRS:i':	tm=pans_i(lambda)
'PAN-STARRS:z':	tm=pans_z(lambda)
'PAN-STARRS:y':	tm=pans_y(lambda)
'SkyMapper:u':	tm=skymapper_u(lambda)
'SkyMapper:v':	tm=skymapper_v(lambda)
'SkyMapper:g':	tm=skymapper_g(lambda)
'SkyMapper:r':	tm=skymapper_r(lambda)
'SkyMapper:i':	tm=skymapper_i(lambda)
'SkyMapper:z':	tm=skymapper_z(lambda)
'DECam:u':	tm=ctiodecam_u(lambda)
'DECam:g':	tm=ctiodecam_g(lambda)
'DECam:r':	tm=ctiodecam_r(lambda)
'DECam:i':	tm=ctiodecam_i(lambda)
'DECam:z':	tm=ctiodecam_z(lambda)
'DECam:Y':	tm=ctiodecam_y(lambda)
'XMM-OT:UVW1':	tm=xmm_uvw1(lambda)
'XMM-OT:UVW2':	tm=xmm_uvw2(lambda)
'XMM-OT:UVM2':	tm=xmm_uvm2(lambda)
'XMM_U':	tm=xmm_u(lambda)
'XMM_B':	tm=xmm_b(lambda)
'XMM_V':	tm=xmm_v(lambda)
endcase
;
return,tm
end
