function filter_cw,filter
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return central wavelength [nm] of a filter by name
;
case filter of
'U':    cw=johnson_u()
'B':    cw=johnson_b()
'V':    cw=johnson_v()
'R':    cw=johnson_r()
'I':    cw=johnson_i()
'J':    cw=johnson_j()
'H':    cw=johnson_h()
'K':    cw=johnson_k()
'L':    cw=johnson_lp()
'M':    cw=johnson_m()
'N':    cw=johnson_n()
'u':    begin
	tm=stroemgren_u(lambda)
	tm=tm*atmosphere[lambda]*aluminium[lambda]^2*pm1p21[lambda]
	end
'v':    begin
	tm=stroemgren_v(lambda)
	tm=tm*atmosphere[lambda]*aluminium[lambda]^2*pm1p21[lambda]
	end
'b':    begin
	tm=stroemgren_b(lambda)
	tm=tm*atmosphere[lambda]*aluminium[lambda]^2*pm1p21[lambda]
	end
'y':    begin
	tm=stroemgren_y(lambda)
	tm=tm*atmosphere[lambda]*aluminium[lambda]^2*pm1p21[lambda]
	end
'm800': cw=mark3_800()
'm550': cw=mark3_550()
'm500': cw=mark3_500()
'm450': cw=mark3_450()
'mhan': cw=mark3_han()
'mhab': cw=mark3_hab()
'm500o':cw=mark3_500o()
	else: cw=0
endcase
;
return,cw
end
