pro fitellipse,e_parms_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fit apparent ellipse to position data. Pass e_parms_in if not determined
; previously (e_parms in common block).
;
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common FitEllipse,ex,ey
;
; Check data
if n_elements(positions) eq 0 then begin
	print,'***Error(FITELLIPSE): no data!'
	return
endif
;
; Check ellipse parameters
if n_elements(e_parms) eq 0 then begin
	if n_elements(e_parms_in) eq 5 then e_parms=e_parms_in else begin
	print,'***Error(FITELLIPSE): no ellipse parms!'
	return
	endelse
endif
;
; Set data.
index=where(positions.rho gt 0 $
	and positions.component eq ellipse_options.component,ndata)
if ndata gt 0 then begin
	p=positions[index].theta
	r=positions[index].rho
	sig=dblarr(ndata)+1
endif else begin
	print,'***Error(FITELLIPSE): no valid data!'
	return
endelse
;
; Set parameters to fit
ma=n_elements(e_parms)
ia=lonarr(ma)
if ellipse_options.all then ia[*]=1 else begin
	if ellipse_options.c then ia[0:1]=1
	if ellipse_options.a then ia[2]=1
	if ellipse_options.b then ia[3]=1
	if ellipse_options.p then ia[4]=1
endelse
index=where(ia ne 0,mfit)
if mfit eq 0 then begin
	print,'***Error(FITELLIPSE): no fit parameters selected!'
	return
endif
a=e_parms
;
; Store ellipse data
ex=r*sin(p)
ey=r*cos(p)
; plot,ex,ey
;
; Call marquardt
marquardt,'ellfuncs',p,r,sig,ndata,a,ia,ma,chisq,covar
;
; Set new parameters
e_parms=a
RAD=180/pi_circle
angle=(e_parms[4]*RAD) mod 360
if angle lt 0 then angle=angle+360
print,'__________________________________'
print,'Center x = ',e_parms[0]
print,'Center y = ',e_parms[1]
print,'Semi-major axis = ',e_parms[2]
print,'Semi-minor axis = ',e_parms[3]
print,'Position  angle = ',angle
print,'_______________***________________'
;
end
