pro fitellipse1
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fit apparent ellipse to position data. Use external library functions.
;
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
; Check data
if n_elements(positions) eq 0 then begin
	print,'***Error(FITELLIPSE): no data!'
	return
endif
;
; Check ellipse parameters
if n_elements(e_parms) eq 0 then begin
	print,'***Error(FITELLIPSE): no ellipse parms!'
	return
endif
;
; Set data. Shift data to array indices 1:n.
index=where(positions.rho gt 0,ndata)
if ndata gt 0 then begin
	p=[0.d0,positions[index].theta]
	r=[0.d0,positions[index].rho]
	sig=dblarr(ndata+1)+1
endif else begin
	print,'***Error(FITELLIPSE): no valid data!'
	return
endelse
;
; Set parameters to fit
ma=n_elements(e_parms)
ia=lonarr(ma+1)
if ellipse_options.all then ia[*]=1 else begin
	if ellipse_options.c then ia[1:2]=1
	if ellipse_options.a then ia[3]=1
	if ellipse_options.b then ia[4]=1
	if ellipse_options.p then ia[5]=1
endelse
index=where(ia ne 0,mfit)
if mfit eq 0 then begin
	print,'***Error(FITELLIPSE): no fit parameters selected!'
	return
endif
a=[0.d0,e_parms]
;
; Store ellipse data
ex=r*sin(p)
ey=r*cos(p)
status=linknload(!external_lib,'store_ell',ex,ey,ndata)
;
; Call marquardt
marquardt1,'ellfuncs',p,r,sig,ndata,a,ia,ma,chisq,covar
;
; Set new parameters
e_parms=a[1:ma]
RAD=180/pi_circle
print,'__________________________________'
print,'Center x = ',e_parms[0]
print,'Center y = ',e_parms[1]
print,'Semi-major axis = ',e_parms[2]
print,'Semi-minor axis = ',e_parms[3]
print,'Position  angle = ',e_parms[4]*RAD
print,'_______________***________________'
;
; Free memory allocated in store_ell
status=linknload(!external_lib,'free_ell',ndata)
;
end
