pro fitnights_rescale,psn_file
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Re-scale astrometric error ellipses (from psn_file) to achieve a Chi^2=1
; given a model. Write psn_file (_rescaled).
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(binary_model) eq 0 then begin
	modelfile=''
	read,modelfile,prompt='Please enter name of model file: '
	readmodel,modelfile
endif
;
l=''
status=dc_read_fixed(psn_file,l,/col,format='(a80)')
if status ne 0 then begin
	print,'Please specify name of astrometry (.psn) file!'
	return
endif else n=n_elements(l)
load_astrometry,psn_file
calcmodel
f=sqrt(modelchisq())
;
new_file=strmid(psn_file,0,strpos(psn_file,'.psn'))+'_rescaled.psn'
openw,unit,new_file,/get_lun
;
for i=0,n-1 do begin
	if strpos(l[i],'!') eq 0 then begin
		printf,unit,l[i]
	endif else begin
		words=nameparse(l[i])
		words[4]=string(float(words[4])*f,format='(f6.3)')
		words[5]=string(float(words[5])*f,format='(f6.3)')
		printf,unit,strjoin(words,'  ')
	endelse
endfor
;
free_lun,unit
;
print,'Rescaled error ellipses, factor =',f
print,'File written: ',new_file
load_astrometry,new_file
calcmodel
;
end
