pro fitorbit1
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fit orbital elements to position data. Use external library functions.
;
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
; Check data
if n_elements(positions) eq 0 then begin
	print,'***Error(FITORBIT): no data!'
	return
endif
;
; Check orbit parameters
if n_elements(o_parms) eq 0 then begin
	print,'***Error(FITORBIT): no orbit parms!'
	return
endif
;
; Check whether orbit parameters have been initialized
if total(o_parms) eq 0 then begin
	print,'***Error(FITORBIT): bad starting model!'
	return
endif
;
; Set data. Shift data to array indices 1:n.
index=where(positions.rho gt 0,ndata)
if ndata gt 0 then begin
	jd=[0.d0,positions[index].jd]
	p=[0.d0,positions[index].theta]
	r=[0.d0,positions[index].rho]
	sig=[1.d0,positions[index].emajor]
endif else begin
	print,'***Error(FITORBIT): no valid data!'
	return
endelse
;
; Set parameters to fit
; RAD=180/3.141592653d0
; o_parms=dblarr(8)
; o_parms(0)=50.0
; o_parms(1)=0.20
; o_parms(2)=127.0/RAD
; o_parms(3)=80.0/RAD
; o_parms(4)=20.0/RAD
; o_parms(5)=103.0
; o_parms(6)=7518.0
;
; Note: o_parms(8) is the orbital sense (not fit).
ma=n_elements(o_parms)-1
ia=lonarr(ma+1)
if orbit_options.all then ia[*]=1 else begin
	if orbit_options.a then ia[1]=1
	if orbit_options.e then ia[2]=1
	if orbit_options.i then ia[3]=1
	if orbit_options.w then ia[4]=1
	if orbit_options.n then ia[5]=1
	if orbit_options.p then ia[6]=1
	if orbit_options.t then ia[7]=1
endelse
index=where(ia ne 0,mfit)
if mfit eq 0 then begin
	print,'***Error(FITORBIT): no fit parameters selected!'
	return
endif
a=[0.d0,o_parms[0:6]]
;
; Store ellipse data
ex=r*sin(p)
ey=r*cos(p)
status=linknload(!external_lib,'store_ell',ex,ey,ndata)
;
; Compute chisq
; xy=true2app(jd,o_parms)
; xy(0,*)=0
; chisq=total(((ex-xy(*,0))/sig)^2+((ey-xy(*,1))/sig)^2)
;
; Set r to zero since orbfuncs does the differences
r=dblarr(ndata+1)
;
; Call marquardt1
marquardt1,'orbfuncs',jd,r,sig,ndata,a,ia,ma,chisq,covar
;
; Set new paramters
o_parms[0:6]=a[1:ma]
RAD=180/pi_circle
print,'__________________________________'
print,'Semi-major axis = ',o_parms[0]
print,'Eccentricity =    ',o_parms[1]
print,'Inclination =     ',o_parms[2]*RAD
print,'Periastron =      ',o_parms[3]*RAD
print,'Ascending node =  ',o_parms[4]*RAD
print,'Period =          ',o_parms[5]
print,'Epoch =           ',o_parms[6]
print,'_______________***________________'
;
; Free memory allocated in store_ell
status=linknload(!external_lib,'free_ell',ndata)
;
end
