function fitshparse,header,keyword_in,quiet=quiet
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Look for keyword in header and return value.
; Remove white space and '.'. Return '' if not found.
;
keyword=strjoin(nameparse(strcompress(strupcase(keyword_in),/remove_all),'.'))
;
n=n_elements(header)
keywords=strarr(n)
values=strarr(n)
for i=0,n-1 do begin
	words=nameparse(header[i],'=')
	keywords[i]=strcompress(words[0],/remove_all)
	if n_elements(words) gt 1 then begin
		value=words[1]
		words=nameparse(value,"/")
		values[i]=strcompress(words[0],/remove_all)
		sl=strlen(values[i])
		if strpos(values[i],"'") eq 0 and $
		   strpos(values[i],"'",/reverse_search) eq sl-1 $
		then values[i]=strmid(values[i],1,sl-2)
	endif
endfor
index=where(strpos(keywords,keyword) ge 0,count)
if count eq 0 then begin
	if not keyword_set(quiet) then print,'Keyword not found!'
	return,''
endif
if count gt 1 then begin
	s_len=strlen(keywords[index])
	j=where(s_len eq min(s_len)) & j=j[0]
endif else j=0
return,values[index[j]]
;
end
