pro fitvolvox
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Used to fit a common set of station coordinates to several night's data.
; Star positions are not fitted.
;
; The coordinates in GenConfig are updated, as well as those in the
; stationtable. However, the constant term in the stationtable, corresponding
; to a path to a common reference in the lab, is incrementally updated
; instead of copying the value from GenConfig.
;
common FitInfo,fit_stations,fit_stars,fit_data,fit_nights,fit_parms
common StarBase,StarTable,Notes
common Tables,scantable,bgtable,stationtable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if checkdata([12,13]) ne 0 then return
;
; Check station and star selection
nstr=n_elements(fit_stars)
nstn=n_elements(fit_stations)
if nstn gt 0 then if fit_stations[0] eq '' then nstn=0
if nstr gt 0 then if fit_stars[0] eq '' then nstr=0
;
; For the common reference station, use the first one in stationtable
; Remove reference station from list, if included
if nstn gt 0 then begin
	index= $
	where(fit_stations ne stationtable[0].stationid,nstn)
	if nstn gt 0 then fit_stations0=fit_stations[index]
endif
;
; Sanity check
if nstn eq 0 then begin
	print,'***Error(FITVOLVOX): no fits were selected!'
	return
endif
;
RAD=180/pi_circle
TOL=1e-8
;
nnit=n_elements(fit_nights)	; number of nights
;
; Determine number of columns, we are not fitting star parameters
nc=nstn*4
;
; Allocate a hopefully sufficient number of rows
nr=1000
;
; Allocate design matrix for this night
m=make_array(nr,nc,/double)
r=make_array(nr,/double)
s=make_array(nc,/string)
;
id=0
;
FOR night=0,nnit-1 DO BEGIN
;
print,'Now processing ',fit_nights[night],'...'
;
words=nameparse(fit_nights[night])
loadnight,words[0],geoinfo[night].systemid,words[1]
calcastrom
index=where(genconfig.stationid eq stationtable[0].stationid,count)
if count gt 0 then referencestation,stationtable[0].stationid,'scan'
;
; Select all scans with valid time stamps
index=where(scans.time gt 0 and scans.starid ne 'FKV0000',count)
if count eq 0 then begin
	print,'Warning(FITVOLVOX): no valid data on ',fit_nights[night],'!'
	goto,SKIP
endif
ha=scans[index].ha*(15/rad)
dec=scans[index].dec/rad
starid=scans[index].starid
geodelay=scans[index].GeoDelay
case fit_data of
	'FDL':begin
	      obsdelay=scans[index].FDLPos
	      obsdelay[GenConfig.RefStation-1,*]=0
	      obsdelayerr=scans[index].FDLPosErr
	      end
	'GRP':begin
	      obsdelay=scans[index].GrpDelay
	      obsdelayerr=scans[index].GrpDelayErr
	      end
	'DRY':begin
	      obsdelay=scans[index].DryDelay
	      obsdelayerr=scans[index].DryDelayErr
	      end
	'WET':begin
	      obsdelay=scans[index].WetDelay
	      obsdelayerr=scans[index].WetDelayErr
	      end
endcase
;
; Extract data for stars if selected
scan_index=indgen(n_elements(starid))
if nstr gt 0 then begin
	id=0
	for i=0,nstr-1 do begin
		index=where(starid eq fit_stars[i],count)
		if count gt 0 then scan_index[id:id+count-1]=index
		id=id+count
	endfor
	if id gt 0 then scan_index=scan_index[0:id-1] else begin
		print,'Warning(FITVOLVOX): no data for stars on ', $
				fit_nights[night],'!'
		goto,SKIP
	endelse
endif
ch=cos(ha[scan_index])
sh=sin(ha[scan_index])
cd=cos(dec[scan_index])
sd=sin(dec[scan_index])
starid=starid[scan_index]
geodelay=geodelay[*,scan_index]
obsdelay=obsdelay[*,scan_index]
obsdelayerr=obsdelayerr[*,scan_index]
;
index=where(obsdelayerr gt 0,nr)
;
; Fill in the design matrix
for i=0,genconfig.numsid-1 do begin
    index_e=where(obsdelayerr[i,*] gt 0,count_e)
    if count_e gt 0 and i ne genconfig.refstation-1 then begin
    wt=1/obsdelayerr[i,index_e]
    r[id:id+count_e-1]=(obsdelay[i,index_e]-geodelay[i,index_e])*wt
    count=0
    index=where(fit_stations0 eq genconfig.stationId[i],count)
    if count ne 0 then begin
		m[id:id+count_e-1,index*4+0]=+cd[index_e]*ch[index_e]*wt; X
		m[id:id+count_e-1,index*4+1]=-cd[index_e]*sh[index_e]*wt; Y
		m[id:id+count_e-1,index*4+2]=+sd[index_e]*wt		; Z
		m[id:id+count_e-1,index*4+3]=-wt			; D
       		if genconfig.stationid[genconfig.refstation-1] $
		ne stationtable[0].stationid then begin
		index=where(fit_stations0 $
			 eq genconfig.stationid[genconfig.refstation-1])
		m[id:id+count_e-1,index*4+0]=-cd[index_e]*ch[index_e]*wt; X
		m[id:id+count_e-1,index*4+1]=+cd[index_e]*sh[index_e]*wt; Y
		m[id:id+count_e-1,index*4+2]=-sd[index_e]*wt		; Z
		m[id:id+count_e-1,index*4+3]=+wt			; D
		endif
    endif
;
    id=id+count_e
    endif
endfor
;
SKIP:
;
ENDFOR
;
; Remove zero rows in the design matrix
index=where(avg(abs(m),1) ne 0,count)
if count gt 0 then begin
	m=m[index,*]
	r=r[index]
	s=s[index]
endif
;
; If data is from white light source only, solve for Constant-Term only
stars=unique(s)
if n_elements(stars) eq 1 and stars[0] eq 'FKV0000' then begin
	do_c_only=1
	nstr=0
	m=m[*,indgen(nstn)*4+3]
endif else begin
	do_c_only=0
endelse
;
; Enough data?
nrow=n_elements(m[*,0])
ncol=n_elements(m[0,*])
if nrow lt ncol then begin
	print,'***Error(FITVOLVOX): not enough data!'
	return
endif
;
t=transpose(m)
n=t#m
y=t#r
;
if n_elements(n) eq 1 then begin
	s=y/n
endif else begin
	svd,n,w,u,v		; Singular value decomposition
; 	print,'Eigenvalues (normalized): ',w/max(w)
	small=where(w lt max(w)*1.0e-8,count)
	if count gt 0 then begin
;	print,'SVD: will edit',count,' singular values!'
		print,'***Error(FITVOLVOX): singular matrix!'
		return
		w[small]=0
	endif
; 	svbksb,u,w,v,y,s	; SVD solution
;
	in=invert(n,status)
	s=in#y			; Direct solution, is more precise
endelse
;
print,'Solution computed.'
;
FOR night=0,nnit-1 DO BEGIN
;
words=nameparse(fit_nights[night])
loadnight,words[0],geoinfo[night].systemid,words[1]
;
; Update the station coordinates
for i=0,nstn-1 do begin
	j=long(where(GenConfig.StationId eq fit_stations0[i]),0)
	if j ge 0 then begin
	ct0=GenConfig.StationCoord[3,j]
	if do_c_only then begin
	GenConfig.StationCoord[3,j]=GenConfig.StationCoord[3,j] $
				   +s[i]
	endif else begin
	GenConfig.StationCoord[*,j]=GenConfig.StationCoord[*,j] $
				   +equatorial2horizon(s[i*4:(i+1)*4-1])
	endelse
	ct1=GenConfig.StationCoord[3,j]
	k=long(where(stationtable.stationid eq fit_stations0[i]),0)
	stationtable[k].x=genconfig.stationcoord[0,j]
	stationtable[k].y=genconfig.stationcoord[1,j]
	stationtable[k].z=genconfig.stationcoord[2,j]
	stationtable[k].d=stationtable[k].d+(ct1-ct0)
	endif
endfor
;
if nstn gt 0 then print,'GenConfig.StationCoord updated for ',fit_nights[night]
;
; Update the astrometry
calcastrom
storenight,11
;
ENDFOR
;
end
