pro fixchafiles,files,n_sigma=n_sigma
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Template to fix problems found in CHA files, e.g., wavelength errors = 0.
; Reads and writes the same CHA file after fixing the error.
;
; The script offeres to make backups of the original files.
;
; Added n_sigma keyword in 2023: flag all visibilities if uncal. visibility is
; negative or with a value less than n_sigma times their absolute error bar.
;
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
num_files=n_elements(files)
if num_files eq 0 then begin
	print,'No files specified, selecting all CHA files...'
	files=file_search('*.cha')
	num_files=n_elements(files)
	if strlen(files[0]) eq 0 then begin
		print,'No CHA files found!'
		return
	endif
endif
answer=''
read,answer,prompt='Backup all modified CHA files (r=return)? (y/n/r) '
answer=strupcase(answer)
if answer eq 'R' then return
if answer eq 'Y' then begin
	spawn,'mkdir -p cha_backup'
	print,'Backups to be created in directory cha_backup.'
endif
;
total_files=0
;
for i=0,n_elements(files)-1 do begin
	hds_open,files[i],'UPDATE'
	fixed=0
	if keyword_set(n_sigma) then begin
		get_scandata
		vissq=scans.vissq ; criterion based on uncal. visibility
		vissqerr=scans.vissqerr
		vissqc=scans.vissqc
		vissqcerr=scans.vissqcerr
		index=where(vissq lt 0 $
			or abs(vissq) lt n_sigma*abs(vissqerr),count)
		if count gt 0 then begin
;			Apply to visibilities (uncalibrated and calibrated)
			vissqerr[index]=-1*abs(vissqerr[index])
			scans.vissqerr=vissqerr
			vissqcerr[index]=-1*abs(vissqcerr[index])
			scans.vissqcerr=vissqcerr
			fixed=1
			if answer eq 'Y' then $
				spawn,'cp -n '+files[i]+' cha_backup'
			print,'Used n_sigma to flag V^2 of file '+files[i]
		endif
	endif else begin
		get_genconfig
		index=where(genconfig.wavelengtherr ne 0,count)
		if count gt 0 then $
			med_err=median(genconfig.wavelengtherr[index]) $
		else med_err=1e-10
		for ob=0,genconfig.numoutbeam-1 do begin
		if total(genconfig.wavelengtherr[*,ob]) eq 0 then begin
			genconfig.wavelengtherr=med_err
			print,'Fixed OB ',ob+1,' of file '+files[i]
			fixed=1
		endif
		endfor
		if fixed and answer eq 'Y' then $
			spawn,'cp -n '+files[i]+' cha_backup'
		put_genconfig
	endelse
	if fixed then begin
		total_files=total_files+1
		hds_close
		put_scandata,files[i]
	endif
endfor
;
print,'Total files fixed: ',total_files
;
end
