pro fixconfiguration
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Fixes wrong configuration info. Only to be called
; immediately after reading scantable, sysconfig (and bgdata) from .con
; files! OYSTER output .cha files must have no configuration
; problems, and therefore this procedure is not allowed to be applied
; after reading these files.
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
;
fixed=0
if system_id(SystemId) eq 'NPOI' then begin
;	Date changes
	if Date eq '1995-03-18' then Date='1996-03-18'
	if Date eq '1995-03-19' then Date='1996-03-19'
	if Date eq '2001-01-07' then Date='2002-01-07'
	if Date eq '2001-01-09' then Date='2002-01-09'
	if Date eq '2001-01-12' then Date='2002-01-12'
	if genconfig.beamcombinerid eq 3 then begin
		if Date eq '2003-03-14' then Date='2003-03-15'
		if Date eq '2003-03-17' then Date='2003-03-18'
		if Date eq '2003-03-18' then Date='2003-03-19'
		if Date eq '2003-03-20' then Date='2003-03-21'
		if Date eq '2002-03-22' then Date='2003-03-23'
		if Date eq '2002-03-23' then Date='2003-03-24'
		if Date eq '2002-03-24' then Date='2003-03-25'
		if Date eq '2002-03-25' then Date='2003-03-26'
	endif
	GenConfig.Date=Date
	GeoParms.Date=Date
;	Date (limited) range section
	parsedate,Date,y,m,d
	if julian(y,m,d) lt julian(1996L,11L,12L) then begin
		fixwavelengths
		fixed=1
	endif
	if julian(y,m,d) lt julian(1997L,02L,11L) then begin
		fixchanwidths
		fixed=1
	endif
	if julian(y,m,d) ge julian(1999L,01L,23L) and $
	   julian(y,m,d) le julian(1999L,03L,22L) then begin
		GenConfig.StationId[0]='AC0'
		GenConfig.StationId[1]='AE0'
		GenConfig.BaselineId[0,0]='AE0-AW0'
		GenConfig.BaselineId[0,1]='AC0-AW0'
		GenConfig.BaselineId[0,2]='AC0-AE0'
		fixed=1
	endif
	if julian(y,m,d) lt julian(2000L,1L,1L) then begin
		GenConfig.SpectrometerId=['1','2','3']
		fixed=1
	endif
;	Moved from 3-way to 6-way combiner, binner cables switched
	if julian(y,m,d) ge julian(2000L,1L,1L) and $
	   julian(y,m,d) lt julian(2001L,9L,25L) then begin
		GenConfig.BeamCombinerId=2
		GenConfig.BCInputId=[2,3,4]
		GenConfig.SpectrometerId=['2','3','1']
		fixed=1
	endif
;	Did not use scanconfig and code for 3-way
	if julian(y,m,d) lt julian(2001L,9L,25L) then begin
		scantable.station[0:2]=1
		scantable.code=1
		fixed=1
	endif
	if julian(y,m,d) ge julian(2001L,9L,25L) and $
	   julian(y,m,d) lt julian(2002L,2L,28L) then begin
		scantable.code=1
		fixed=1
	endif
	if julian(y,m,d) ge julian(2001L,9L,25L) and $
	   julian(y,m,d) le julian(2002L,3L,3L) then begin
		scantable.station[0:5]=1
		genconfig.spectrometerid=['2','3']
		genconfig.siderostatid=[6,1,2,3,5,4]
		genconfig.sidconid=[6,1,2,3,5,4]
		fixed=1
	endif
;	H-alpha used for much of 2011, but wavelengh info wrong!
	if julian(y,m,d) ge julian(2011L,1L,1L) and $
	   julian(y,m,d) lt julian(2011L,5L,11L) then begin
		fixwavelengths,'2006-10-19.s1.s3.wavelengths'
		fixed=1
	endif
;	Imaging setup used early 2013, but wavelengh info wrong!
	if julian(y,m,d) ge julian(2013L,1L,1L) and $
	   julian(y,m,d) lt julian(2013L,3L,28L) then begin
		fixwavelengths,'2008-01-15.s1.s3.wavelengths'
		fixed=1
	endif
;	Bad system.config file with OB1 wavelength error set to zero
	if julian(y,m,d) ge julian(2014L,7L,6L) and $
	   julian(y,m,d) lt julian(2016L,4L,28L) then begin
	   index=where(genconfig.wavelengtherr ne 0,count)
	   if count gt 0 then med_err=median(genconfig.wavelengtherr[index]) $
		         else med_err=1e-10
	for ob=0,genconfig.numoutbeam-1 do $
		if total(genconfig.wavelengtherr[*,ob]) eq 0 $
		then genconfig.wavelengtherr=med_err
		fixed=1
	endif
;
;	Date (unlimited) range section (watch this!)
	index=where(total(scantable.station[0:genconfig.numsid-1],1) le 1 $
		and scantable.code eq 1,count)
	if count gt 0 then scantable[index].code=0
;
;	Date (single) only
	if Date eq '1996-05-01' then begin
		index=where(StarTable.starid eq 'FKV0001')
		StarTable[index].starid='FKV0000'
		fixed=1
	endif
	if Date eq '1996-05-02' then begin
		index=where(startable.starid eq 'FKV0001')
		StarTable[index].starid='FKV0000'
		fixed=1
	endif
	if Date eq '1996-03-18' then begin
		GenConfig.StationId[0]='AC0'
		GenConfig.StationId[1]='AE0'
		GenConfig.StationId[2]='AW0'
		GenConfig.BaselineId[0,0]='AE0-AW0'
		GenConfig.BaselineId[0,1]='AC0-AW0'
		GenConfig.BaselineId[0,2]='AC0-AE0'
		fixed=1
	endif
	if Date eq '1996-03-19' then begin
		GenConfig.StationId[0]='AC0'
		GenConfig.StationId[1]='AE0'
		GenConfig.StationId[2]='AW0'
		GenConfig.BaselineId[0,0]='AE0-AW0'
		GenConfig.BaselineId[0,1]='AC0-AW0'
		GenConfig.BaselineId[0,2]='AC0-AE0'
		fixed=1
	endif
	if Date eq '1997-01-11' then begin
		numscan=25
		numbgscan=24
		stars=['FKV0074','FKV0100','FKV0074','FKV0100','FKV0074', $
		       'FKV0100','FKV0074','FKV0100','FKV0139','BSC1412', $
		       'FKV0139','BSC1412','FKV0139','BSC1412','FKV0139', $
		       'BSC1412','FKV0139','BSC1412','FKV0139','BSC1412', $
		       'BSC2095','FKV1137','BSC2095','FKV1137','BSC2095']
		ScanTable.starid=stars
		ScanTable.scanid=indgen(numscan)+1
		if n_elements(BGTable) ne 0 then $
			BGTable.scanid=indgen(numbgscan)+1
		fixed=1
	endif
	if Date eq '1997-01-31' then begin
		numscan=20
		numbgscan=18
		stars=['FKV0100','FKV0100','FKV0202','FKV0202','FKV0202', $
		       'BSC2095','FKV1137','BSC2095','FKV1137','BSC2095', $
		       'FKV1137','BSC2095','FKV1137','FKV0251','FKV0295', $
		       'FKV0251','FKV0295','FKV0251','FKV0237','FKV0316']
		ScanTable.starid=stars
		ScanTable.scanid=indgen(numscan)+1
		if n_elements(BGTable) ne 0 then $
			BGTable.scanid=[1,2,4,5,7,8,9,10,11,12,13,14,15,16, $
					17,18,19,20]
		fixed=1
	endif
	if Date eq '1997-02-01' then begin
		numscan=3
		numbgscan=2
		stars=['FKV0251','FKV0295','FKV0251']
		ScanTable.starid=stars
		ScanTable.scanid=indgen(numscan)+1
		if n_elements(BGTable) ne 0 then $
			BGTable.scanid=[1,2]
		fixed=1
	endif
	if Date eq '1997-02-04' then begin
		numscan=45
		numbgscan=45
		stars=['FKV0100','FKV0074','FKV0100','FKV0074','FKV0100', $
		       'FKV0074','FKV0100','FKV0074','FKV0251','FKV0295', $
		       'FKV0251','FKV0295','FKV0251','FKV0295','FKV0251', $
		       'FKV0295','FKV0251','FKV0295','FKV0251','FKV0295', $
		       'FKV0251','FKV0295','FKV0251','FKV0295','FKV0365', $
		       'FKV0379','FKV0365','FKV0379','FKV0365','FKV0379', $
		       'FKV0365','FKV0379','FKV0365','FKV0379','FKV0365', $
		       'FKV0379','FKV0365','FKV0379','FKV0365','FKV0379', $
		       'FKV0365','FKV0365','FKV0379','FKV0365','FKV0379']
		ScanTable.starid=stars
		ScanTable.scanid=indgen(numscan)+1
		if n_elements(BGTable) ne 0 then $
			BGTable.scanid=indgen(numbgscan)+1
		fixed=1
	endif
	if Date eq '1997-05-14' then begin
		ScanTable[0:4].starid= $
			['FKV0423','FKV2897','FKV0423','FKV1302','FKV1311']
	endif
	if Date eq '1998-11-18' then begin
		GenConfig.StationId[1]='E04'
		GenConfig.BaselineId[0,0]='E04-AW0'
		GenConfig.BaselineId[0,2]='AC0-E04'
;		3-way was used, but we want compatibility with 6-way
		GenConfig.BeamCombinerId=2
		GenConfig.BCInputId=[2,3,4]
		fixed=1
	endif
	if Date eq '1998-12-16' then begin
		GenConfig.StationId[0]='E02'
		GenConfig.BaselineId[0,1]='E02-AW0'
		GenConfig.BaselineId[0,2]='E02-AE0'
;		3-way was used, but we want compatibility with 6-way
		GenConfig.BeamCombinerId=2
		GenConfig.BCInputId=[2,3,4]
		fixed=1
	endif
	if Date eq '1998-12-18' then begin
		GenConfig.StationId[0]='E02'
		GenConfig.BaselineId[0,1]='E02-AW0'
		GenConfig.BaselineId[0,2]='E02-AE0'
;		3-way was used, but we want compatibility with 6-way
		GenConfig.BeamCombinerId=2
		GenConfig.BCInputId=[2,3,4]
		fixed=1
	endif
	if Date eq '1999-01-08' then begin
		GenConfig.StationId[0]='E02'
		GenConfig.StationId[1]='E04'
		GenConfig.BaselineId[0,0]='E04-AW0'
		GenConfig.BaselineId[0,1]='E02-AW0'
		GenConfig.BaselineId[0,2]='E02-E04'
;		3-way was used, but we want compatibility with 6-way
		GenConfig.BeamCombinerId=2
		GenConfig.BCInputId=[2,3,4]
		fixed=1
	endif
	if Date eq '2000-07-22' then begin
		index=scanindex([24619,25645,26809,27393,28257,29990,30762, $
       				 33164,35533])
		if index[0] ge 0 then scantable[index].code=0
		fixed=1
	endif
	if Date eq '2000-09-20' then begin
		scantable[[1,5,7,9,11,13,15,17,19,44]].code=0
		fixed=1
	endif
	if Date eq '2001-03-20' then begin
		GenConfig.StationId[0]='AN0'
		GenConfig.BaselineId[0,1]='AN0-AW0'
		GenConfig.BaselineId[0,2]='AN0-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-03-22' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-03-28' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-03-30' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-03-31' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-04-09' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-05-02' then begin
		GenConfig.StationId[2]='E02'
		GenConfig.BaselineId[0,0]='AE0-E02'
		GenConfig.BaselineId[0,1]='AC0-E02'
		GenConfig.BCInputId[2]=1
		GenConfig.DelayLineId[2]=1
		fixed=1
	endif
	if Date eq '2001-05-10' then begin
		GenConfig.StationId[2]='E02'
		GenConfig.BaselineId[0,0]='AE0-E02'
		GenConfig.BaselineId[0,1]='AC0-E02'
		GenConfig.BCInputId[2]=1
		GenConfig.DelayLineId[2]=1
		fixed=1
	endif
	if Date eq '2001-05-16' then begin
		GenConfig.StationId[2]='E02'
		GenConfig.BaselineId[0,0]='AE0-E02'
		GenConfig.BaselineId[0,1]='AC0-E02'
		GenConfig.BCInputId[2]=1
		GenConfig.DelayLineId[2]=1
		fixed=1
	endif
	if Date eq '2001-05-25' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-05-26' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-05-27' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-06-01' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-06-08' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-06-10' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-06-21' then begin
		index=scanindex([18535,19824,20292,20974,21497,22157, $
				 22537,23039,23462,24099,24694,25177, $
				 25706,26703,28285,28899,29517,41077, $
				 41557])
		if index[0] ge 0 then scantable[index].code=0
		fixed=1
	endif
	if Date eq '2001-06-27' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-06-28' then begin
		GenConfig.StationId[0]='W07'
		GenConfig.BaselineId[0,1]='W07-AW0'
		GenConfig.BaselineId[0,2]='W07-AE0'
		GenConfig.BCInputId[0]=5
		GenConfig.DelayLineId[0]=5
		fixed=1
	endif
	if Date eq '2001-11-03' then begin
		scantable.station=0
		scantable.station[1]=1
		scantable.station[3]=1
		scantable[0:3].station(2)=1
		scantable[8:11].station(0)=1
		fixed=1
	endif
	if Date eq '2001-11-14' then begin
		scantable.code=0
		scantable.station=0
		stations=scantable.station
		stations[[1,2,3,5,4],[0,1,2,3,4]]=1
		scantable.station=stations
		fixed=1
	endif
	if Date eq '2001-11-17' then begin
		scantable.station=0
		scantable[[0,6,7,13,18,19,20,21,22]].station(0)=1
		scantable[[0,1,7,8,14,15,16,17]].station(1)=1
		scantable[[0,2,7,9]].station(2)=1
		scantable[[0,3,7,10,14,15,16,17,18,19,20,21,22]].station(3)=1
		scantable[[0,5,7,12]].station(4)=1
		scantable[[0,4,7,11]].station(5)=1
		scantable.code=0
		scantable[[14,16,18,20,21]].code=1
		fixed=1
	endif
	if Date eq '2001-11-20' then begin
		scantable.station=0
		scantable[0].station=1
		scantable.station[3]=1
		scantable[[1,2,3,4]].station(2)=1
		scantable[[5,6,7,8]].station(0)=1
		scantable[[9,10,11,12]].station(5)=1
		scantable[[13,14]].station(4)=1
		scantable[[2,4,6,8,10,12,14]].code=0
		fixed=1
	endif
	if Date eq '2001-11-21' then begin
		scantable[[1,3,5,7,9]].code=0
		scantable.station=0
		scantable.station[[0,2,3]]=1
		fixed=1
	endif
	if Date eq '2002-01-09' then begin
		scantable[[1,3,5,7,9,12,16,18]].code=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		scantable.station=1
		fixed=1
	endif
	if Date eq '2002-01-12' then begin
		scantable[[1,3,5,7,9,13,15,18,20]].code=0
		scantable.station=1
		scantable[6:10].station([1,4,5])=0
		scantable[11:16].station([1,5])=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-01-25' then begin
		index=scanindex([19837,20802,21435,22180,24439,25150, $
				 28626,29882,31781,32253,33507,34209, $
				 35216,36043,38291,39045,40173,42879, $
				 44595])
		if index[0] ge 0 then scantable[index].code=0
		scantable.station=1
		index=scanindex([23608,24439,24802,25150])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-01-26' then begin
		index=scanindex([23417,27407,30948,33337,33919,34481, $
				 35026,37707,38409,39053,40280,40928, $
				 42353,44738])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex([30691,30948,33133,33337,33654,33919, $
				 34231,34481,34775,35026])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([38151,38409,38794,39053,39776,40280, $
				 40596,40928])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-01' then begin
		index=scanindex([17989,20020,22858,24640,26958,30621, $
				 32834,35115,36336,36977])
		if index[0] ge 0 then scantable[index].code=0
		scantable.station=1
		index=scanindex([24031,24640,26464,26958,27576,28268])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([29966,30621,32557,32834])
		if index[0] ge 0 then scantable[index].station(4:5)=0
		index=scanindex([36046,36336,36721,36977,37237,37468, $
				 37770,38634,39244,39541,40255,40859, $
				 41529,42312,42765])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-06' then begin
		index=scanindex([13908,16255,24259,25883,26443,28208, $
				 29478,30504,32043,32565,33350,34644, $
				 39185,39570,42371,43202,43784,44312])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex([25268,25883,26194,26443])
		if index[0] ge 0 then scantable[index].station([0,4])=0
		index=scanindex([28783,29478,30123,30504])
		if index[0] ge 0 then scantable[index].station(4:5)=0
		index=scanindex([31490,32043,32354,32565])
		if index[0] ge 0 then scantable[index].station(5)=0
		index=scanindex([38755,39185,39392,39570,39798,40065, $
				 40314,40605,40847,41078,41569])
		if index[0] ge 0 then scantable[index].station([0,1,4])=0
		index=scanindex([42011,42371])
		if index[0] ge 0 then scantable[index].station([1,4])=0
		index=scanindex([42726,43202])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([43516,43784])
		if index[0] ge 0 then scantable[index].station([1,4])=0
		index=scanindex([44089,44312])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-07' then begin
		index=scanindex([22764,30621,31379,33202,34366,36973, $
				 37670,39149,40293])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex([21725,22764])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([36412,36973,37429,37670,38022,38587, $
				 38889,39149,39706,40293,41237,41745, $
				 42025])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([38587,38889,39149,39706,40293,41237, $
				 41745,42025])
		if index[0] ge 0 then scantable[index].station(0)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-12' then begin
		scantable.station[2]=0
		scantable.station[5]=0
		index=scanindex([14086,14930,16233,17522,18731,21272, $
				 22821,24082,24800])
		if index[0] ge 0 then scantable[index].code=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-13' then begin
		index=scanindex([26313,27562,29495,30639,32634,34091, $
				 34984])
		if index[0] ge 0 then scantable[index].code=0
		scantable.station[[1,2,4]]=0
		index=scanindex([28903,29495,30272,30639,32055,32634])
		if index[0] ge 0 then scantable[index].station(1)=1
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-14' then begin
		index=scanindex([26348,28263,29781,32791,33502,34364, $
				 35099,36149,37224,37518,37754,38058, $
				 41773])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex([27859,28263,29208,29781])
		if index[0] ge 0 then scantable[index].station(5)=0
		index=scanindex([33166,33502])
		if index[0] ge 0 then scantable[index].station([4,5])=0
		index=scanindex([33968,34364])
		if index[0] ge 0 then scantable[index].station(0)=0
		index=scanindex([34830,35099])
		if index[0] ge 0 then scantable[index].station([1,2])=0
		index=scanindex([37224])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([37518])
		if index[0] ge 0 then scantable[index].station([0,2,3,4])=0
		index=scanindex([37754])
		if index[0] ge 0 then scantable[index].station([0,1,3,5])=0
		index=scanindex([38058])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-15' then begin
		index=scanindex([12148,13107,14171,14817,16733,23605, $
				 24791,25309,25816,26788,27292,28087, $
				 28499,29195,29560,30015,30187,30498, $
				 30711,30926,31839,32261,32518,34102, $
				 35990,36503,37364,39786,40204,42132, $
				 42805])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex([24505,24791,25102,25309])
		if index[0] ge 0 then scantable[index].station([2,5])=0
		index=scanindex([25629,25816,26788,27106,27292])
		if index[0] ge 0 then scantable[index].station(2)=0
		index=scanindex([28338,28499])
		if index[0] ge 0 then scantable[index].station(4:5)=0
		index=scanindex([29036,29195])
		if index[0] ge 0 then scantable[index].station(0)=0
		index=scanindex([29404,29560])
		if index[0] ge 0 then scantable[index].station(1:2)=0
		index=scanindex([30187])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([30498])
		if index[0] ge 0 then scantable[index].station([0,2,3,4])=0
		index=scanindex([30711])
		if index[0] ge 0 then scantable[index].station([0,1,3,5])=0
		index=scanindex([30926])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([39564,39786,40013,40204])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([41926,42132,42533,42805])
		if index[0] ge 0 then scantable[index].station([1,4])=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-20' then begin
		index=scanindex([25989,26222,26500,26758,28523,30473, $
				     36520,37640,38312,39194])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex(25989)
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex(26222)
		if index[0] ge 0 then scantable[index].station([0,2,3,4])=0
		index=scanindex(26500)
		if index[0] ge 0 then scantable[index].station([0,1,3,5])=0
		index=scanindex(26758)
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-23' then begin
		index=scanindex([12109,20339,22084,23157,23582,26100, $
				 39361,40502,42395,43030])
		if index[0] ge 0 then scantable[index].code=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-26' then begin
		index=scanindex([17738,24339,28390,28754,29116,29394, $
				 33756,37409])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex(28390)
		if index[0] ge 0 then scantable[index].station=[1,0,0,0,0,0]
		index=scanindex(28754)
		if index[0] ge 0 then scantable[index].station=[0,1,0,0,0,1]
		index=scanindex(29116)
		if index[0] ge 0 then scantable[index].station=[0,0,1,0,1,0]
		index=scanindex(29394)
		if index[0] ge 0 then scantable[index].station=[0,0,0,1,0,0]
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-27' then begin
		if scanindex(28299) ne -1 then begin
			scantable[scanindex(28299)].starid='FKV0380'
			scantable[scanindex(28299)].scanid=1
		endif
		index=scanindex([28948,29609,30003,30868,31428,33226, $
				     34383,35389,36487])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex(29609)
		if index[0] ge 0 then scantable[index].station=[1,0,0,0,0,0]
		index=scanindex(30003)
		if index[0] ge 0 then scantable[index].station=[0,1,0,0,0,1]
		index=scanindex(30868)
		if index[0] ge 0 then scantable[index].station=[0,0,0,1,0,0]
		index=scanindex(31428)
		if index[0] ge 0 then scantable[index].station=[1,1,0,1,0,1]
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-02-28' then begin
		if scanindex(24117) ne -1 then begin
			scantable[scanindex(24117)].starid='FKV0380'
			scantable[scanindex(24117)].scanid=0
			scantable[scanindex(24117)].code=1
		endif
		if scanindex(29817) ge 0 then begin
			scantable[scanindex(29817)].starid='FKV0380'
			scantable[scanindex(29817)].code=1
		endif
		index=scanindex(27314)
		if index[0] ge 0 then scantable[index].station=[1,0,0,0,0,0]
		index=scanindex(27610)
		if index[0] ge 0 then scantable[index].station=[0,1,0,0,0,1]
		index=scanindex(27839)
		if index[0] ge 0 then scantable[index].station=[0,0,0,1,0,0]
		index=scanindex(28216)
		if index[0] ge 0 then scantable[index].station=[1,1,0,1,0,1]
		index=scanindex([29817,30813,32570,32825,33148, $
				     33684])
		if index[0] ge 0 then scantable[index].station([2,4])=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-03-01' then begin
		fixed=1
		scantable.station=0
 		index=scanindex([15284,18112,20141,20592,21237,21850, $
 				 22499,23510,24975,25486,25899,26701, $
 				 27076,27862,28185,28608,28991,29275, $
 				 30576,30993,31450,32221,33732,34825, $
 				 35137,35600,36049,36404,37110,37363, $
 				 37696,38078,38630,38922,40442,41186, $
 				 41434,42030,42814,43185,43507,43853, $
 				 44963,45248,45522,45730,46410])
		if index[0] ge 0 then scantable[index].station(0)=1
 		index=scanindex([16376,18112,20592,21237,21850,22829, $
 				 23510,24975,25486,25899,26701,27327, $
 				 27862,28185,28608,28991,29600,30576, $
 				 30993,31450,32221,33924,34825,35137, $
 				 35600,36049,36607,37110,37363,37696, $
 				 38078,39413,39759,40666,41186,41434, $
 				 42030,42814,43185,44262,44490,44963, $
 				 45248,45522,45730,46097])
		if index[0] ge 0 then scantable[index].station([1,5])=1
 		index=scanindex([17699,18112,20141,20592,21237,21850, $
 				 23108,23510,24975,25486,25899,26701, $
 				 27546,27862,28185,28608,28991,30059, $
 				 30576,30993,31450,32221,34096,34825, $
 				 35137,35600,36049,36829,37110,37363, $
 				 37696,38078,38630,38922,39413,39759, $
 				 40904,41186,41434,42030,42814,43185, $
 				 43507,43853,44262,44490,44963,45248, $
 				 45522,45730,45925])
		if index[0] ge 0 then scantable[index].station(3)=1
 		index=scanindex([15284,16376,17699,18112,22499,22829, $
 				 23108,23510,27076,27327,27546,27862, $
 				 29275,29600,30059,30576,33732,33924, $
 				 34096,34825,36404,36607,36829,37110, $
 				 38630,39413,40442,40666,40904,41186, $
 				 43507,44262,45730,45925,46097,46410])
		if index[0] ge 0 then scantable[index].code=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
	endif
	if Date eq '2002-03-02' then begin
		scantable.station[2]=0
		scantable.station[4]=0
 		index=scanindex([15861,16119,18123,18361,20183,20351, $
 				 22700,22866,25037,25194,26699,26875, $
 				 28939,29120,29953,30187,31939,32219, $
 				 32985,33140,34620,34770,35232,35477, $
 				 36973,37362,38000,38208,39511,39680, $
 				 40499,40709,42936,43203,44193,44830, $
 				 44985])
		if index[0] ge 0 then scantable[index].station(0)=0
 		index=scanindex([15171,16119,17929,18361,20014,20351, $
 				 22217,22866,24812,25194,26530,26875, $
 				 28113,28266,29641,30187,31509,31688, $
 				 32786,33140,34271,34424,35003,35477, $
 				 36604,36768,37746,38208,39155,39319, $
 				 40193,40709,42406,42697,44640,44985])
		if index[0] ge 0 then scantable[index].station(1)=0
 		index=scanindex([15171,15861,17929,18123,20014,20183, $
 				 22217,22700,24812,25037,26530,26699, $
 				 29641,29953,32786,32985,35003,35232, $
 				 37746,38000,40193,40499,44640,44830])
		if index[0] ge 0 then scantable[index].station(3)=0
 		index=scanindex([15171,16119,17929,18361,20014,20351, $
 				 22217,22866,24812,25194,26530,26875, $
 				 28113,28266,29641,30187,31509,31688, $
 				 32786,33140,34271,34424,35003,35477, $
 				 36604,36768,37746,38208,39155,39319, $
 				 40193,40709,42406,42697,44640,44985])
		if index[0] ge 0 then scantable[index].station(5)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-03-15' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-03-20' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-03-21' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-03-27' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-03-31' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-04-02' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-04-03' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-04-10' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-04-12' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-04-13' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-04-14' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-04-26' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-04-28' then begin
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-05-03' then begin
		scantable.station[4]=0
		index=scanindex([14454,14782,15462,15814,16024,16490, $
				 16793,17115,17379,18979,19210,19589, $
				 19827,20213,20489,20725,21059,21300, $
				 22060,22454,22684,23232,23464,23874, $
				 24148,24793,25129,26278,26474,26953, $
				 27237,27849,28187,28507,28751,33099, $
				 33326,35546,35770,36079,36298,37489, $
				 37709,37924,38147])
		if index[0] ge 0 then scantable[index].station(0)=0
		index=scanindex([34377,34694,34951,35207,36534,36797, $
				 37036,37258])
		if index[0] ge 0 then scantable[index].station(2)=0
		index=scanindex([16490,16793,17115,17379,20213,20489, $
				 20725,21059,21300,23874,24148,24793, $
				 25129,27849,28187,28507,28751,33099, $
				 33326,35546,35770,36079,36298,37489, $
				 37709,37924,38147])
		if index[0] ge 0 then scantable[index].station(5)=0
		GenConfig.Wavelength[*,0]=[862.2,831.6,803.5,777.5,753.5,731.3,710.5,552.5, $
					   542.5,656.3,533.0,524.0,515.4,598.3,585.9,574.1]*1e-9
		GenConfig.Wavelength[*,1]=[862.2,831.6,803.5,777.5,753.5,731.3,710.5,552.5, $
					   542.5,656.3,533.0,524.0,515.4,598.3,585.9,574.1]*1e-9
		GenConfig.SiderostatId=[6,1,2,3,5,4]
		GenConfig.SidConId=[6,1,2,3,5,4]
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-05-04' then begin
		scantable.station[4]=0
		index=scanindex([30483,30714,31003,31225,36518,36733, $
				     37090,37317,38605,38825,39037,39261])
		if index[0] ge 0 then scantable[index].station([0,5])=0
		GenConfig.Wavelength[*,0]=[862.2,831.6,803.5,777.5,753.5,731.3,710.5,552.5, $
					   542.5,656.3,533.0,524.0,515.4,598.3,585.9,574.1]*1e-9
		GenConfig.Wavelength[*,1]=[862.2,831.6,803.5,777.5,753.5,731.3,710.5,552.5, $
					   542.5,656.3,533.0,524.0,515.4,598.3,585.9,574.1]*1e-9
		GenConfig.SiderostatId=[6,1,2,3,5,4]
		GenConfig.SidConId=[6,1,2,3,5,4]
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-05-08' then begin
		scantable.station[4]=0
		index=scanindex([18323,19090,20669,21181,22407,23219,24273,25476, $
				 26527,26856,27781,28218,29258,29716,30623,30935, $
				 32922,33205,33478,36025,36368,38425,39064,40083, $
				 40404,41453,41744])
		if index[0] ge 0 then scantable[index].station([0,5])=0
		GenConfig.Wavelength[*,0]=[862.2,831.6,803.5,777.5,753.5,731.3,710.5,552.5, $
					   542.5,656.3,533.0,524.0,515.4,598.3,585.9,574.1]*1e-9
		GenConfig.Wavelength[*,1]=[862.2,831.6,803.5,777.5,753.5,731.3,710.5,552.5, $
					   542.5,656.3,533.0,524.0,515.4,598.3,585.9,574.1]*1e-9
		GenConfig.SiderostatId=[6,1,2,3,5,4]
		GenConfig.SidConId=[6,1,2,3,5,4]
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-05-09' then begin
		scantable.station[4]=0
		index=scanindex([16114,16339,16789,18208,18579,19877,20129,21364, $
				 21672,22464,22848,23558,23852,24985,25278,26241, $
				 26528,27217,27541,28426,28769,29683,30590,31652, $
				 31876,32169,33295,34146,34871,35186,35873,36344, $
				 37347,37818,38652,38925,39706,39981,40703,41021, $
				 41735,42124,42819])
		if index[0] ge 0 then scantable[index].station([0,5])=0
		GenConfig.Wavelength[*,0]=[862.2,831.6,803.5,777.5,753.5,731.3,710.5,552.5, $
					   542.5,656.3,533.0,524.0,515.4,598.3,585.9,574.1]*1e-9
		GenConfig.Wavelength[*,1]=[862.2,831.6,803.5,777.5,753.5,731.3,710.5,552.5, $
					   542.5,656.3,533.0,524.0,515.4,598.3,585.9,574.1]*1e-9
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-05-11' then begin
		scantable.station[4]=0
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-05-12' then begin
		scantable.station[[4,5]]=0
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-05-15' then begin
		scantable.station[4]=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-16' then begin
		scantable.station[4]=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-18' then begin
		index=scanindex([28624,28876,29113,29510,30061,30358,31144, $
				 31372,31680,31970,32456,32686,33089,33312, $
				 33655,33872,34574,34828,35202,35439,35685, $
				 35915])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([39222,39470,39697,39929])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-19' then begin
		index=scanindex([27898,28123,30574,30770,31005,31385,31700, $
				 32041,32329,32620,32942,33225])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([37807,38024,38246,38680,38901,39111,39381, $
				 39590,39814,40035,40246,40463,40679,41122, $
				 41441,41667,41887,42364,42655])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-20' then begin
		index=scanindex([29208,29425,29908,30111,30444,30683,31289, $
				 31501,31904,32122,32736,33014,33505,34356, $
				 34542,35000,35229,35555,36031,36866,37196, $
				 37471,38098,38456,38793,39141,39386,39743, $
				 40074,40349,40727,41128,41352,41648,41936])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-22' then begin
		scantable.station[4]=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-23' then begin
		index=scanindex([28091,28404,28705,29059,29301,29766,30113, $
				 30462,30740,31453,31997,32322,32693,33004, $
				 33244,33941,34341,34956,36142,36444,36710, $
				 36931,37196,37418,37662,37877,38107,38369, $
				 38656,38881,39106,39558,39798,40144,40366, $
				 40737,40956,41174,41469,42237])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-24' then begin
		index=scanindex([27447,27680,27973,28205,28515,28740,29222, $
				 29514,29787,30025,30251,30543,30789,31047, $
				 31396,31665,31963,32327,32660])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([39897,40120,40367,40588,40804,41109,41522, $
				 41811,42084,42385])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-25' then begin
		index=scanindex([26813,27082,27317,27540,28027,28285, $
				 28523,28761,29100,29354,29570,29787, $
				 30162,30344,30558,30776,31033,31251, $
				 31471,31689,31979,32188,32452,32680, $
				 33058,33278,33518,33739,34092,34309, $
				 34538,34757,34986,35306,35510,35729, $
				 35962,36185,36409,36624,37059,37288, $
				 37520,37741,38165,38393,38643,38865, $
				 39313,39534,39751,39969])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2002-05-29' then begin
		index=scanindex([26171,26397,26810,27033,27295,27535, $
				 27921,28226,29107,29447,29872,30205, $
				 30632,30914,31232,31592,31966,32345, $
				 32629,33045,33308,33849,34076,34361, $
				 34601,34876,35092,35383,35626,35839, $
				 36069,36334,36624,36884,37106,37376, $
				 37598,38085,38305,38606,38848,39667, $
				 39986,40329,40548,40853,41079,41338, $
				 41575,41833,42088])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
	if Date eq '2002-05-30' then begin
		index=scanindex([25372,25639,26029,26300,33635,33907, $
				 34136,34390,34611,34831,35062,35345, $
				 35586,35832,36071,36312,36579,36829, $
				 37051,37389,37640,38173,38385,38725, $
				 38946,39381,39627,39986,40280,40880, $
				 41128,41493,41760])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
	if Date eq '2002-05-31' then begin
		index=scanindex([24822,25071,25378,25655,25886,26115, $
       				 26388,26657,27052,27293,27730,27967, $
       				 28230,28481,28843,29108,29365,29621, $
       				 29933,30166,30629,30895,31259,31518, $
       				 31763,32165,32440,32759,33023,33260, $
       				 33502,33776,34035,34393,34646,34949, $
       				 35217,35661,35923,36335,36636,37452, $
       				 37720,37985,38248,38465,38695,38934, $
       				 39162,39383,39605,39826,40050,40347, $
       				 40531,40827,41110,41657,41866,42337, $
       				 42519])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
	if Date eq '2002-06-02' then begin
		index=scanindex([22982,23225,23463,23753,24032,24273, $
       				 24502,24771,24970,25194,25423,25864, $
       				 26118,26417,26641,27151,27355,27723, $
       				 27982,28285,28481,28767,28961,29624, $
       				 29904,30177,30425,30795,31032,31311, $
       				 31584,31812,32042,32329,32600,33046, $
       				 33324,33645,33895,34155])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([36232,36576,36798,37092,37359,37659, $
       				 37883,38156,38422])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([40005,40188,40563,40789,41048,41373, $
       				 41545,42014,42241])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
	if Date eq '2002-06-03' then begin
		index=scanindex([23024,23251,23510,23769,23979,24203, $
       				 24490,24757,24972,25197,25423,25663, $
       				 25943,26170,26541,26755,27023,27245, $
       				 27488,27717,28082,28304,28620,28853, $
       				 29091,29312,29583,29795,30603,30833, $
       				 31135,31326,31598,31832,32078,32325, $
       				 32594,32839,33168,33413])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([35210,36938,37170,37464,37648,37928, $
       				 38171,38440,38621])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([40656,40909,41426,41717])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
	if Date eq '2002-06-04' then begin
		index=scanindex([25167,25409,26363,26589,26808,27033, $
       				 27347,27575,27895,28208,28724,29145, $
       				 29495,29730,30323,30652,30956,31208, $
       				 31529,31765,32261,32612,32906,33129, $
       				 33463,33774,34002,34221,34493,34739, $
       				 35364,35638,36289,36725,37494,37858, $
       				 38379,38596,39515,39912,41198,41528, $
       				 41969,42211])
		if index[0] ge 0 then scantable[index].station(4)=0
		genconfig.baselineid[*,0]=['AE0-E02','AE0-AW0','AN0-AW0', $
					   'AE0-AN0','E02-AN0','E02-AW0']
		genconfig.baselineid[*,1]=['E02-AC0','AW0-AC0','W07-AW0', $
					   'W07-AC0','W07-E02','E02-AW0']
		fixed=1
	endif
	if Date eq '2002-06-05' then begin
		index=scanindex([24501,24840,25553,25800,26149,26388, $
       				 26874,27222,27575,27823,28387,28624, $
       				 30198,30536,30836,31064,31423,31682, $
       				 32228,32449,33111,33399,34107,34436, $
       				 34719,34986,35509,35837,36958,37281, $
       				 37618,37928,38298,38556,39900,40151, $
       				 40463,40763,41375,41683,42255,42482])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
	if Date eq '2002-06-06' then begin
		index=scanindex([24415,24639,24892,25138,25470,25760, $
       				 25984,26215,26466,26684,27040,27277, $
       				 27668,27904,28297,28536,28904,29155, $
       				 29390,29624,29869,30096,30345,30569, $
       				 31029,31253,31470,31899,32117,32339, $
       				 32595,32834,33065,33287,33518,33740, $
       				 34019,34246,34552,34787,35372,35606, $
       				 35895,36128,36393,36654,36884,37106, $
       				 37837,38094,38462,38710,38958,39231, $
       				 39665,40131,40349,40675,40939,41544, $
       				 41788])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
	if Date eq '2002-06-07' then begin
		index=scanindex([22191,22441,22743,23020,23272,23526, $
       				 23833,24032,24480,24703,25043,25221, $
       				 25439,25685,25917,26200,26384,26612, $
       				 26833,27116,27337,27671,27899,28170, $
       				 28365,28632,28867,29189,29362,29605, $
       				 29904,30128,30433,30700,31135,31436, $
       				 31867,32082,32327])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([34307,34554,35136,35594,35797,36096, $
       				 36326,36681,36921,37529,37749,38040, $
       				 38238])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([41440,41635,41904,42118,42500,42694])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
	if Date eq '2002-06-08' then begin
		scantable.station[4]=0
		fixed=1
	endif
	if Date eq '2002-06-10' then begin
		index=scanindex([23872,24077,24320,24570,24859,25145,25443, $
       				 25692,26071,26379,26780,27095,27764,28006, $
       				 28243,28476,29125,29455,29679,29902,31142, $
       				 31460,33206,33442,33906,34181,34689,34917, $
       				 35245])
		if index[0] ge 0 then scantable[index].station(4)=0
		fixed=1
	endif
        if Date eq '2002-06-23' then begin
                index=scanindex([14621,14830,15174,15470,17026,17272,17678, $
                                 17968,19688,20012,20233,21088,21289,21547, $
                                 21778,23143,23382,23600,25147,25387,25599, $
                                 26964,27194,27412,27640,28798,29054,29294])
                if index[0] ge 0 then scantable[index].station(4)=0
                GenConfig.Wavelength[*,0]=[862.2,831.6,803.5,777.5,753.5,731.3,7
                                           542.5,656.3,533.0,524.0,515.4,598.3,5
                GenConfig.Wavelength[*,1]=[862.2,831.6,803.5,777.5,753.5,731.3,7
                                           542.5,656.3,533.0,524.0,515.4,598.3,5
                fixed=1
        endif
	if Date eq '2002-06-30' then begin
		scantable.station[4]=0
		fixed=1
	endif
	if Date eq '2002-07-01' then begin
		scantable.station[4]=0
		index=scanindex([25485,25840,26068,27117,27354,28570,28760, $
				 29836,33099,33327,33562,33908,35329,35671, $
				 36579,36766,37035,37271,37493,38579,38855, $
				 39629,39853,40820,41061,41434,41682])
		if index[0] ge 0 then scantable[index].station(5)=0
		fixed=1
	endif
	if Date eq '2002-07-06' then begin
		scantable.station[5]=0
		index=scanindex([23132,23404,23632,23851,24263,25774,26039, $
       				 26257,26494,26714,26969,27197,27416,27634, $
       				 27853,28213,28567,28786,29008,29226,29635, $
       				 29898,30192,30412,30655])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([23851,26257,27416,28786,30192])
		if index[0] ge 0 then scantable[index].station([1,2,3])=0
		index=scanindex([24263,26494,27634,29008,30412])
		if index[0] ge 0 then scantable[index].station([0,1,2])=0
		index=scanindex([25774,26714,27853,29226,30655])
		if index[0] ge 0 then scantable[index].station([0,3])=0
		index=scanindex([31895,33517,35087,37063,39750,41816])
		if index[0] ge 0 then scantable[index].station([1,2,3,4])=0
		index=scanindex([32114,33736,35309,37332,40057,42033])
		if index[0] ge 0 then scantable[index].station([0,1,2,4])=0
		index=scanindex([32335,33954,35529,37552,40293,42325])
		if index[0] ge 0 then scantable[index].station([0,3,4])=0
		index=scanindex([32555,34178,35748,37769,40585,42543])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-07-07' then begin
		scantable.station[5]=0
		index=scanindex([15318,15576,15796,16055,16275,20235,20459, $
       				 20696,20915,21134,21528,21773,21962,22179, $
       				 22398,22969,23222,23439,23658,23875,24136, $
       				 24374,24627,24845,25073,25295,25545,25771, $
       				 25991,26215,26489,26713,26933,27185,27406, $
       				 28326,28528,28715,29002,29232,29483,29705])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([15796,20696,21962,23439,24627,25771,26933, $
				 29232])
		if index[0] ge 0 then scantable[index].station([1,2,3])=0
		index=scanindex([16055,20915,22179,23658,24845,25991,27185, $
				 29483])
		if index[0] ge 0 then scantable[index].station([0,1,2])=0
		index=scanindex([16275,21134,22398,23875,25073,26215,27406, $
       				 29705])
		if index[0] ge 0 then scantable[index].station([0,3])=0
		index=scanindex([16053,20694,25543,27183,29481,30612,31077, $
				 31315,31637,32245,33307,35116,37909,41705,42669])
		if index[0] ge 0 then scantable[index].code=0
		index=scanindex([30835,32471,34388,36346,38192,39943,41707])
		if index[0] ge 0 then scantable[index].station([1,2,3,4])=0
		index=scanindex([31079,32689,34614,36624,38425,40163,41944,42174])
		if index[0] ge 0 then scantable[index].station([0,1,2,4])=0
		index=scanindex([31317,32909,33309,34836,36842,38887,40382,42394])
		if index[0] ge 0 then scantable[index].station([0,3,4])=0
		index=scanindex([31639,33534,35118,37060,39133,40601,42669])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-07-08' then begin
		scantable.station[5]=0
		index=scanindex([18518,18875,19163,19471,19708,20405,20709, $
       				 20933,21208,21429,21792,22014,22233,22456, $
       				 22814,23100,23418,23636,24348,24605,24830, $
       				 25113,25605,26132,26466,26701,26923,27180, $
       				 27415,27634,27860,28091,28607,28875,29116, $
       				 29338,29597])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([19163,20933,22014,23100,24830,26466,27634, $
				 29116])
		if index[0] ge 0 then scantable[index].station([1,2,3])=0
		index=scanindex([19471,21208,22233,23418,25113,26701,27860, $
				 29338])
		if index[0] ge 0 then scantable[index].station([0,1,2])=0
		index=scanindex([19708,21429,22456,23636,25605,26923,28091, $
				 29597])
		if index[0] ge 0 then scantable[index].station([0,3])=0
		index=scanindex([32617,36231,38384,41367])
		if index[0] ge 0 then scantable[index].station([1,2,3,4])=0
		index=scanindex([32908,36510,41595])
		if index[0] ge 0 then scantable[index].station([0,1,2,4])=0
		index=scanindex([33227,36818,39123,41815])
		if index[0] ge 0 then scantable[index].station([0,3,4])=0
		index=scanindex([33445,37055,40846,42038])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-07-13' then begin
		scantable.station[4]=0
		index=scanindex([22491,24080,25800,27138,29376,31269, $
       				 32738,34289,36531,38057,39588,41196])
		if index[0] ge 0 then scantable[index].station([1,2,3,5])=0
		index=scanindex([22708,24297,26017,27357,29827,32962, $
       				 34511,36752,38288,39809,41459])
		if index[0] ge 0 then scantable[index].station([0,1,2,5])=0
		index=scanindex([22977,24639,26236,27578,28099,30107,33184, $
       				 34740,37017,38530,40027,41689])
		if index[0] ge 0 then scantable[index].station([0,3,5])=0
		index=scanindex([23197,24868,26453,27875,30326,33502, $
       				 34969,37258,38757,40263,42226])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		index=scanindex([22977,27875,33502,37017,38530,41459])
		if index[0] ge 0 then scantable[index].code=0
		fixed=1
	endif
	if Date eq '2002-07-21' then begin
		scantable.code=0
		index=scanindex([37714,39505])
		if index[0] ge 0 then scantable[index].code=1
		index=scanindex([38187,39962])
		if index[0] ge 0 then scantable[index].station([1,2,3,5])=0
		index=scanindex([38459,40183])
		if index[0] ge 0 then scantable[index].station([0,1,2,5])=0
		index=scanindex([38702,40441])
		if index[0] ge 0 then scantable[index].station([0,3,5])=0
		index=scanindex([39004,40659])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-07-23' then begin
;		Incomplete!
		index=scanindex([23244,23469,23720,24059,24289,24528, $
       				 32570,32792,33023,33296,33697,34105])
		if index[0] ge 0 then scantable[index].station(4)=1
		index=scanindex([38187,39962])
		if index[0] ge 0 then scantable[index].station([1,2,3,5])=0
		index=scanindex([38459,40183])
		if index[0] ge 0 then scantable[index].station([0,1,2,5])=0
		index=scanindex([38702,40441])
		if index[0] ge 0 then scantable[index].station([0,3,5])=0
		index=scanindex([39004,40659])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-08' then begin
		index=scanindex([17381,17607,17825,18043,18268,18489, $
       				 18735,19123,19346,19566,19785,20065, $
       				 20368,20587,20812,21033,21261,21482, $
       				 21926,22258,22482,22708,22927,23169, $
       				 23514,23751,23970,24190,24406,25036, $
       				 25426,25674,25913,26133,26355,26574])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([17825,19346,20812,22482,23970,25913, $
       				 28162,30143,31951,33731,37597,39295, $
       				 41080,42686])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([18043,19566,21033,22708,24190,26133, $
       				 28389,30365,32171,33941,37812,39511, $
       				 41303,42908])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([18268,19785,21261,22927,24406,26355, $
       				 29131,30582,32418,34279,38028,39851, $
       				 41538,43126])
		if index[0] ge 0 then scantable[index].station([0,3,4,5])=0
		index=scanindex([18489,20065,21482,23169,25036,26574, $
       				 29636,30804,32718,34628,38308,40116, $
       				 41826,43345])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-09' then begin
		scantable.station[5]=0
		index=scanindex([24974,27309,28856,30884,32655,34124, $
       				 35606,37855,39901,41434,42904])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([25196,27533,29078,31111,32873,34345, $
       				 35827,38108,40122,41651,43122])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([25451,27759,29297,31349,33095,34564, $
       				 36199,38328,40343,41873,43343])
		if index[0] ge 0 then scantable[index].station([0,3,4,5])=0
		index=scanindex([25677,28019,29576,31568,33313,34786, $
       				 36420,39110,40562,42093,43560])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-11' then begin
		index=scanindex([17209,17431,17652,17870,18089,18365, $
       				 18679,18901,19142,19360,19625,19848, $
       				 20153,20373,20591,20813,21031,21271, $
       				 21571,21792,22010,22229,22447,22674, $
       				 23092,23418,23547])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([17652,19360,20813,22229,22447,31043, $
       				 33162,34542,37933,39409,40828,42471])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([17870,19625,21031,22674,23092,31264,33389, $
       				 34763,38153,39631,41048,42691])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([18089,19848,21271,23418,23547,31483,33625, $
       				 34983,38374,39852,41273,42921])
		if index[0] ge 0 then scantable[index].station([0,3,4,5])=0
		index=scanindex([18365,19142,20591,22010,26032,30825, $
       				 32639,34320,37713,39177,40605,42252])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-12' then begin
		scantable.station[5]=0
		index=scanindex([15094,15314,15531,15753,15973,16211, $
       				 16448,16667,16888,17107,17364,17596, $
       				 17813,18032,18252,18750,18976,19198, $
       				 19425,19645,20446,20671,20941,21379, $
       				 21693,21930,22141,22361,22579,22797, $
       				 23059,23296,23513,23733,23951])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([15531,16667,17813,19198,20941,22361, $
       				 23513,25010,26479,28014,29992,31423, $
       				 33184,34923,36538,38888,40348])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([15753,16888,18032,19425,21379,22579, $
       				 23733,25226,26696,28231,30210,31641, $
       				 33402,35144,36757,39107,40565])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([15973,17107,18252,19645,21693,22797, $
       				 23951,25445,26913,28447,30428,31864, $
       				 33618,35363,36974,39338,40787])
		if index[0] ge 0 then scantable[index].station([0,3,4,5])=0
		index=scanindex([25663,27132,28667,30648,32118,33834, $
       				 35587,37191,39555,41007])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-14' then begin
		index=scanindex([17263,17487,17714,17930,18183,18451, $
       				 18866,19092,19314,19538,19756,20048, $
       				 20440,20660,20903,21124,21357,21573, $
       				 22664,22931,23148,23417,23641,23858, $
       				 24234,24492,24710,24932,25590,25807, $
       				 26300,26530,26747,26968])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([17714,19314,20903,23148,24710,26747, $
       				 28367,30018,31679,33498,35250,37390, $
       				 38879,40945,42495])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([17930,19538,21124,23417,24932,26968, $
       				 28588,30240,31912,33723,35468,37609, $
       				 39098,41167,42712])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([18183,19756,21357,23641,25590,27189, $
       				 28858,30478,32198,33966,35690,37825, $
       				 39333,41436,42937])
		if index[0] ge 0 then scantable[index].station([0,3,4,5])=0
		index=scanindex([18451,20048,21573,23858,25807,27444, $
       				 29231,30696,32249,32490,34183,35929,38045, $
       				 39710,41664,43193])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-15' then begin
		index=scanindex([13524,13796,14127,14383,14632,14929, $
       				 15341,15614,15840,16159,16474,16843, $
       				 17256,17487,17708,17927,18149,18377, $
       				 18758,18983,19203,19420,19639,19876, $
       				 20154,20382,20603,20855,21071,21303, $
       				 21628,21876,22157,22376,22603,22819, $
       				 23301,23580,23775,23991,24209,24440, $
       				 24766,25020,25244,25460,25675,25891, $
       				 26693,26941,27146,27371,27587,27882, $
       				 28219,28459,28763,28983,29203,29465])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([14127,15840,17708,19203,20603,22157, $
       				 23775,25244,27146,28763,30694,32095, $
       				 33749,35425,36960,38580,40134,41877])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([14383,16159,17927,19420,20855,22376, $
       				 23991,25460,27371,28983,30918,32313, $
       				 33969,35645,37176,38798,40352,42094])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([14632,16474,18149,19639,21071,22603, $
       				 24209,25675,27587,29203,31169,32532, $
       				 34185,35867,37402,39015,40575,42295])
		if index[0] ge 0 then scantable[index].station([0,3,4,5])=0
		index=scanindex([14929,16843,18377,19876,21303,22819, $
       				 24440,25891,27882,29465,31384,32750, $
       				 34417,36103,37621,39251,40903,42503])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-16' then begin
		index=scanindex([18094,18334,21116,21339,21528,21773, $
       				 21992,22258,22476,22782,23170,23480, $
       				 23931,24189,24501,24789,24991,25212, $
       				 25434,25654])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([21528,21773,24991,26655,30364,32000, $
       				 33780,35476,36943,38898,40666,42151])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([21992,25212,26877,30584,32228,34001, $
       				 35707,37160,39117,40886,42369])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([22258,25434,27101,30813,32458,34227, $
       				 35941,37380,39568,41108,42596])
		if index[0] ge 0 then scantable[index].station([0,3,4,5])=0
		index=scanindex([22476,25654,27328,31102,31258,32683, $
       				 34451,36172,37609,39792,41329,42818])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-17' then begin
		scantable.station[[2,4]]=0
		index=scanindex([16691,18843,20568,25057,26955,30061, $
       				 32445,34158,35895,37691,40035,41751])
		if index[0] ge 0 then scantable[index].station([1,3,5])=0
		index=scanindex([16946,19063,20796,25343,27333,30288, $
       				 32712,34378,36117,37949,40245,41983])
		if index[0] ge 0 then scantable[index].station([0,3])=0
		index=scanindex([17177,19284,21022,25606,27659,30510, $
       				 32934,34603,36336,38171,40483,42203])
		if index[0] ge 0 then scantable[index].station([0,1,5])=0
		fixed=1
	endif
	if Date eq '2002-08-18' then begin
		scantable.station[[2,4]]=0
		index=scanindex([14908,17036,18586,20572,22465,24163, $
       				 26481,26702,28324,30155,31776,33412, $
       				 35082,36662,38275,39856,42844])
		if index[0] ge 0 then scantable[index].station([1,3,5])=0
		index=scanindex([15141,17261,18807,20793,22692,24389, $
       				 26702,26922,28542,30372,31993,33632, $
       				 35299,36881,38493,40074,43062])
		if index[0] ge 0 then scantable[index].station([0,3])=0
		index=scanindex([15709,17481,19033,21094,22912,24612, $
       				 26922,27145,28762,30590,32209,33850, $
       				 35516,37101,38709,40291,43281])
		if index[0] ge 0 then scantable[index].station([0,1,5])=0
		fixed=1
	endif
	if Date eq '2002-08-23' then begin
		scantable.station[[2,4]]=0
		index=scanindex([13185,14787,17790,19479,21277,23174, $
       				 25133,26875,28661,30638,31365,35664, $
       				 40849,41201])
		if index[0] ge 0 then scantable[index].station([1,3,5])=0
		index=scanindex([13406,15010,18023,19703,21502,23427, $
       				 25327,27095,28904,30906,31595,35861])
		if index[0] ge 0 then scantable[index].station([0,3])=0
		index=scanindex([13626,15241,18245,19961,21733,23654, $
       				 25561,27332,29124,31139,36086])
		if index[0] ge 0 then scantable[index].station([0,1,5])=0
		fixed=1
	endif
	if Date eq '2002-08-24' then begin
		scantable.station[[2,4]]=0
		index=scanindex([14046,15634,17156,17224,18878,20606, $
       				 22255,23795,25391,26973,28536,30155, $
       				 31726,33280,36032,37747,39297,40998, $
       				 42587])
		if index[0] ge 0 then scantable[index].station([1,3,5])=0
		index=scanindex([14313,15852,17420,19094,20828, $
       				 22477,24018,25616,27189,28753,30373, $
       				 31948,33501,36380,37973,39518,41218, $
       				 42807])
		if index[0] ge 0 then scantable[index].station([0,3])=0
		index=scanindex([14533,16080,17638,19314,21046, $
       				 22695,24248,25834,27408,28974,30592, $
       				 32166,33724,36597,38195,39832,41437, $
       				 43032])
		if index[0] ge 0 then scantable[index].station([0,1,5])=0
		fixed=1
	endif
	if Date eq '2002-08-26' then begin
		scantable.station[[2,4]]=0
		index=scanindex([19674,23822,25330,27032,28657,30229, $
       				 31920,34023])
		if index[0] ge 0 then scantable[index].station([1,3,5])=0
		index=scanindex([19894,24040,25546,27315,28875,30550, $
       				 32144,34243])
		if index[0] ge 0 then scantable[index].station([0,3])=0
		index=scanindex([20116,24258,25764,27534,29095,30775, $
       			 	 32364,34463])
		if index[0] ge 0 then scantable[index].station([0,1,5])=0
		fixed=1
	endif
	if Date eq '2002-08-30' then begin
		scantable.station[4]=0
		index=scanindex([16964,18421,20236,21663,23071,24653, $
       				 26196,27563,29159,30552,32278,33745, $
       				 35472,36906,38450,39933,41934])
		if index[0] ge 0 then scantable[index].station([1,2,3,5])=0
		index=scanindex([17188,18647,20459,21884,23288,24875, $
       				 26431,27783,29378,30769,32510,33970, $
       				 35702,37126,38675,40153,42156])
		if index[0] ge 0 then scantable[index].station([0,1,2,5])=0
		index=scanindex([17406,18864,20678,22102,23505,25096, $
       				 26649,28004,29604,30990,32741,34188, $
       				 35955,37354,38918,40391,42384])
		if index[0] ge 0 then scantable[index].station([0,3,5])=0
		index=scanindex([17622,19084,20895,22327,23723,25320, $
       				 26870,28227,29824,31334,32975,34413, $
       				 36172,37578,39140,40609,42604])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-08-31' then begin
		scantable.station[4]=0
		index=scanindex([14503,15852,17255,19770,21295,22802, $
       				 24476,25954,27508,29023,30417])
		if index[0] ge 0 then scantable[index].station([1,2,3,5])=0
		index=scanindex([14727,16070,17473,19991,21526,23041, $
       				 24701,26238,27748,29248,30636])
		if index[0] ge 0 then scantable[index].station([0,1,2,5])=0
		index=scanindex([14946,16290,17696,17936,20216,21753,23384, $
       				 24948,26471,27985,29467,30855])
		if index[0] ge 0 then scantable[index].station([0,3,5])=0
		index=scanindex([15163,16514,18730,20434,21978,23612, $
       				 25183,26697,28221,29695,31134])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-09-02' then begin
		scantable.station[4]=0
		index=scanindex([22621,24336,25851,28331,29728,31698, $
       				 33966,36067,38059,40518])
		if index[0] ge 0 then scantable[index].station([1,2,3,5])=0
		index=scanindex([24554,26119,28577,30101,31977, $
       				 34295,36286,38328,40747])
		if index[0] ge 0 then scantable[index].station([0,1,2,5])=0
		index=scanindex([22922,24820,26342,28798,30411,32231, $
       				 34578,36664,38633,41070])
		if index[0] ge 0 then scantable[index].station([0,3,5])=0
		index=scanindex([23144,25044,26653,29109,30674,32526, $
       				 34966,36914,38928,41431])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-09-03' then begin
		scantable.station[4]=0
		index=scanindex([27007,28491,30935,32607,34568,37286, $
       				 39750])
		if index[0] ge 0 then scantable[index].station([1,2,3,5])=0
		index=scanindex([27225,28707,31187,32827,34824,37535, $
       				 39970])
		if index[0] ge 0 then scantable[index].station([0,1,2,5])=0
		index=scanindex([27444,28926,31405,33044,35067,37762, $
       				 40277])
		if index[0] ge 0 then scantable[index].station([0,3,5])=0
		index=scanindex([27667,29191,31661,33314,35536,37981, $
       				 40582])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-09-05' then begin
		index=scanindex([33121,33363,33608,33872,34154,35153, $
       				 35411,35630,35852,38175,38654,38893, $
       				 39151,39388,39723,40706,40955,41203, $
       				 41606,41888,42107,42563,42803,42998, $
       				 43248,43591,43821])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([24033,29041,31320,33608,35153,38893, $
       				 41203,42998])
		if index[0] ge 0 then scantable[index].station([1,2,3,4,5])=0
		index=scanindex([24270,29262,31567,33872,35411,39151, $
       				 41606,43248])
		if index[0] ge 0 then scantable[index].station([0,1,2,4,5])=0
		index=scanindex([24609,29520,31883,34154,35630,39388, $
       				 41888,43591])
		if index[0] ge 0 then scantable[index].station([0,3,4,5])=0
		index=scanindex([24987,29886,32113,35852,39723,42107, $
       				 43821])
		if index[0] ge 0 then scantable[index].station([0,1,2,3])=0
		fixed=1
	endif
	if Date eq '2002-09-13' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-09-14' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-09-15' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-09-20' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-09-21' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-09-22' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-09-23' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-09-24' then begin
		scantable.station[[1,5]]=0
		index=scanindex([25557,27080,27249,27337])
		if index[0] ge 0 then scantable[index].station=0
		index=scanindex([42362,42621,42841,43060,43285,43540,43806, $
       				 44110,44334,44593,44934,45165,45404,45625, $
       				 45843,46227,46464])
		if index[0] ge 0 then scantable[index].station(4)=0
		index=scanindex([25105,26406,28280,29382,30734,32118,34174, $
       				 36043,42841,44110,45404])
		if index[0] ge 0 then scantable[index].station([2,3,4])=0
		index=scanindex([25276,26640,28402,29578,30925,32347,34427, $
       				 36262,43060,44334,45625])
		if index[0] ge 0 then scantable[index].station([2,0,4])=0
		index=scanindex([25429,26767,28546,29796,31175,32581,34592, $
       				 36583,43285,44593,45843])
		if index[0] ge 0 then scantable[index].station([3,0])=0
		fixed=1
	endif
	if Date eq '2002-09-25' then begin
		scantable.station[[1,5]]=0
		index=scanindex([15486,20259])
		if index[0] ge 0 then scantable[index].station=0
		index=scanindex([14953,16128,17127,19578,20839,22273, $
       				 23283,24768,25799,30798,33259,34634, $
       				 36061,37523,39008,40340,41974,43789])
		if index[0] ge 0 then scantable[index].station([2,3,4])=0
		index=scanindex([15094,16329,17231,19744,21056,22375, $
       				 23491,24883,25922,31021,33476,34850, $
       				 36278,37738,39226,40557,42282,44007])
		if index[0] ge 0 then scantable[index].station([2,0,4])=0
		index=scanindex([15245,16433,17434,19901,21276,22439, $
       				 23587,25053,26100,31238,33719,35069, $
       				 36494,37954,39494,40881,42702,44223])
		if index[0] ge 0 then scantable[index].station([3,0])=0
		fixed=1
	endif
	if Date eq '2002-10-01' then begin
		scantable.station[[1,5]]=0
		index=scanindex([18654,20295,21644,23759,25419,28540, $
       				 30085,31990,33644,35144,36686,39077, $
       				 40986,42886,44965])
		if index[0] ge 0 then scantable[index].station([2,3,4])=0
		index=scanindex([18959,20412,21861,23983,25641,28804, $
       				 30308,32215,33874,35364,36904,39346, $
       				 41206,43134,45180,45259])
		if index[0] ge 0 then scantable[index].station([2,0,4])=0
		index=scanindex([19191,20628,22124,24342,25892,29032, $
       				 30718,32452,34099,35604,37123,39716, $
       				 41424,43361,45471])
		if index[0] ge 0 then scantable[index].station([3,0])=0
		fixed=1
	endif
	if Date eq '2002-10-09' then begin
		scantable.station[[0,4,5]]=0
		genconfig.baselineid[1,1]='AC0-AW0'
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-10-10' then begin
		scantable.station[[0,4,5]]=0
		genconfig.baselineid[1,1]='AC0-AW0'
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-10-11' then begin
		scantable.station[[0,4,5]]=0
		genconfig.baselineid[1,1]='AC0-AW0'
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-10-14' then begin
		scantable.station[[0,4,5]]=0
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2002-10-17' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-10-22' then begin
		scantable.station[[0,4,5]]=0
		fixed=1
	endif
	if Date eq '2002-11-07' then begin
		scantable.station[4]=0
		genconfig.spectrometerid=[1,3]
		fixed=1
	endif
	if Date eq '2003-01-03' then begin
		scantable.station[3]=0
		fixed=1
	endif
	if Date eq '2003-01-04' then begin
		genconfig.beamcombinerid=3
		scantable.station[3]=0
		GenConfig.Wavelength[*,0]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		GenConfig.Wavelength[*,1]=[849.4,820.9,793.9,768.3,744.2,722.9,701.5,683.1, $
					   664.6,648.9,617.7,603.5,590.7,577.9,566.5,556.6]*1e-9
		fixed=1
	endif
	if Date eq '2003-01-05' then begin
		scantable.station[3]=0
		genconfig.beamcombinerid=3
		fixed=1
	endif
	if Date eq '2003-01-06' then begin
		scantable.station[3]=0
		fixed=1
	endif
	if Date eq '2003-01-07' then begin
		scantable.station[3]=0
		fixed=1
	endif
	if Date eq '2004-05-29' then begin
		genconfig.chanwidth[8:15,1]=genconfig.chanwidth[8:15,0]
		fixed=1
	endif
	if Date eq '2004-06-03' then begin
		genconfig.chanwidth[8:15,1]=genconfig.chanwidth[8:15,0]
		fixed=1
	endif
	if Date eq '2011-01-29' then begin
		fixwavelengths,'2006-10-19.s1.s3.wavelengths'
	endif
	if Date eq '2011-12-01' then begin
		fixwavelengths,'2007-01-20.s2.s3.wavelengths'
	endif
	if Date eq '2013-12-25' then begin
		k=genconfig.refstation-1
		index=where(scantable.station[k] eq 0 and $
			    scantable.code eq 1)
		scantable[index].code=0
		fixed=1
	endif
	if Date eq '2015-04-30' then begin
		i=where(scantable.starid eq 'FKV1417')
		scantable[i].code=1
		fixed=1
	endif
endif
;
if fixed then begin
	print,'Fixed configuration.'
endif
;
end
