pro fixrefstation
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
; Check if the genconfig.refstation was part of the array at all times
;
k=genconfig.refstation-1
index=where(scantable.station[k] eq 0 and $
	    scantable.code eq 1,count)
if count gt 0 then scantable[index].code=0
;
index=where(scantable.code eq 1,count)
if count eq 0 then return	; No coherent scans: should not happen
index=where(total(scantable[index].station(0:genconfig.numsid-1),2) eq count)
jndex=where(index eq genconfig.refstation-1,count)
if count eq 0 then begin
;	genconfig.refstation was not always in use, change to one which was
	refstation=index[0]+1
	referencestation,GenConfig.StationId[refstation-1],'point'
	print,'Warning(GET_POINTS): reference station changed to ' $
		+string(refstation,format='(i1)')+'!'
endif
;
end
