function fixstarids,StarId
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; The Mark3 and also NPOI have been using fake FKV and BSC IDs, respectively,
; for stars not found in these catalogs. Because stellar parameters are not
; saved in the data files but read from external catalogs, we need to translate
; these to other catalogs (Hipparcos), or the USR ("user") catalog.
;
common NPOI,npoi_cat,npoi_hip
common Mark3,mark3_baselines,mark3_configs,mark3_cat,mark3_bsc
;
; Replace Mark3 FKV numbers >= 1700 <= 2001 with corresponding BSC numbers
for i=0,n_elements(mark3_cat)-1 do begin
	index=where(StarId eq mark3_cat[i],count)
	if count gt 0 then StarId[index]=mark3_bsc[i]
endfor
; Replace NPOI fake BSC numbers >= 9111 with corresponding HIP/USR numbers
for i=0,n_elements(npoi_cat)-1 do begin
	index=where(StarId eq npoi_cat[i],count)
	if count gt 0 then StarId[index]=npoi_hip[i]
endfor
;
; Added for version 9 to get fixed lengths of StarIds
index=where(strmid(StarId,0,3) eq 'HDN' and strlen(StarId) lt 9,count)
for i=0,count-1 do begin
;	ID=long(strmid(StarId(index(i)),3,5))
;	There are cases such as HDN_5300...
	ID=long(strmid(strjoin(nameparse(StarId[index[i]],['_','-'])),3,5))
	StarId[index[i]]=strmid(StarId[index[i]],0,3)+string(ID,format='(i6.6)')
endfor
;
index=where(strmid(StarId,0,3) eq 'HIP' and strlen(StarId) lt 9,count)
for i=0,count-1 do begin
;	ID=long(strmid(StarId(index(i)),3,5))
;	There are cases such as HIP_5300...
	ID=long(strmid(strjoin(nameparse(StarId[index[i]],['_','-'])),3,5))
	StarId[index[i]]=strmid(StarId[index[i]],0,3)+string(ID,format='(i6.6)')
endfor
;
starids=StarId
return,starids
;
end
