pro flag_channels,channels,all=all
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Flag squared visibility data of the star defined in gen_model
; in the given channels. Only applies to data loaded in the buffer!
;
; If keyword all is set, edit data for all stars.
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ModelFit,parameters,ds_options
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common AuxData,parallaxes,k1,k2,vsini
;
; Check dimensions of scans.vissq
if n_elements(size(scans.vissqc)) ne 7 then begin
	print,'***Error(FLAG_CHANNELS): procedure can only handle 4 dimensions!'
	return
endif
;
; Check if model file is loaded
if not keyword_set(all) and n_elements(gen_model) eq 0 then begin
	print,'***Error(FLAG_CHANNELS): procedure needs a model file!'
	return
endif
;
; Interferometry
if ds_options.i ne 0 then begin
;
nights=geninfo.date
arrays=geoinfo.systemid
confgs=geninfo.configid
wf=1/sqrt(ds_options.i)
for n=0,n_elements(nights)-1 do begin
	night=where(GenInfo.date eq nights[n] $
		and GeoInfo.systemid eq arrays[n] $
		and GenInfo.configid eq confgs[n])
	if n_elements(bufferinfo) gt 1 then $
	loadnight,GenInfo[night[0]].date, $
		  GeoInfo[night[0]].systemid, $
		  GenInfo[night[0]].configid
;
; 	Channel selection
	ns=n_elements(scans)
	if not keyword_set(all) then $
		index=where(scans.starid eq gen_model.starid,ns) $
		else $
		index=indgen(ns)
;
	if ns gt 0 then begin
;
	if ds_options.v2 eq 1 then begin
		r=size(scans[index].vissqc,/dim)
		if n_elements(r) ne 4 then begin
		   print,'Error: can only handle VisSq w/4 dimensions!'
		   return
		endif
		for ob=0,r[0]-1 do scans[*].vissqcerr(ob,channels-1,*) $
			       =-1*abs(scans[*].vissqcerr(ob,channels-1,*))
		if n_elements(geninfo) gt 1 then storenight,11l
	endif else print,'No V2 data found for '+nights[n]
;
	if ds_options.tp eq 1 then begin
		r=size(scans[index].triplephasec,/dim)
		if n_elements(r) ne 3 then begin
		   print,'Error: can only handle TriplePhaseC w/3 dimensions!'
		   return
		endif
		for tr=0,r[0]-1 do scans[*].triplephasecerr(tr,channels-1,*) $
			=-1*abs(scans[*].triplephasecerr(tr,channels-1,*))
		if n_elements(geninfo) gt 1 then storenight,11l
	endif else print,'No TP data found for '+nights[n]
;
	if ds_options.ta eq 1 then begin
		r=size(scans[index].tripleampc,/dim)
		if n_elements(r) ne 3 then begin
		   print,'Error: can only handle TripleAmpC w/3 dimensions!'
		   return
		endif
		for tr=0,r[0]-1 do scans[*].tripleampcerr(tr,channels-1,*) $
			=-1*abs(scans[*].tripleampcerr(tr,channels-1,*))
		if n_elements(geninfo) gt 1 then storenight,11l
	endif else print,'No TA data found for '+nights[n]
;
	endif else print,'No data found for this star in '+nights[n]+'!'
endfor
;
endif
;
end
