pro flag_visibilities
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Flag squared visibility data of the star defined in gen_model where
; they are inconsistent with the model values at the level of 3 sigma
; or more. Only applies to data loaded in the buffer!
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
common ModelFit,parameters,ds_options
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common AuxData,parallaxes,k1,k2,vsini
;
y=0.d0
ysig=0.d0
ymod=0.d0
;
; Interferometry
if ds_options.i ne 0 then begin
	nights=geninfo.date
	arrays=geoinfo.systemid
	confgs=geninfo.configid
	wf=1/sqrt(ds_options.i)
	for n=0,n_elements(nights)-1 do begin
		night=where(GenInfo.date eq nights[n] $
			and GeoInfo.systemid eq arrays[n] $
			and GenInfo.configid eq confgs[n])
		if n_elements(bufferinfo) gt 1 then $
		loadnight,GenInfo[night[0]].date, $
			  GeoInfo[night[0]].systemid, $
			  GenInfo[night[0]].configid
;
; 		Scan selection
		index=where(scans.starid eq gen_model.starid,NS)
		if ns gt 0 and ds_options.v2 eq 1 then begin
			r=size(scans[index].vissqc,/dim)
			ndata=n_elements(scans[index].vissqc)
			y=reform(scans[index].vissqc,ndata)
			ysig=reform(scans[index].vissqcerr,ndata)
			ymod=reform(scans[index].vissqm,ndata)
			bad=where(abs(y-ymod) gt 2*ysig and ysig gt 0,count)
			if count gt 0 then ysig[bad]=-ysig[bad]
			scans[index].vissqcerr=reform(ysig,r)
			storenight,11l
		endif else print,'No V2 data found for '+nights[n]
	endfor
endif
;
end
