pro flagbgdata,flagtable,flag=flag
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Applies (flag=1) or removes (flag=-1) flags of flag table in BG data.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if not keyword_set(flag) then flag=1L else flag=long(flag)
if(flag ne 1) and (flag ne -1) then begin
	print,'***Error(FLAGBGDATA): flag must be 1 (flag) or -1 (unflag)!'
	return
endif
;
numflag=n_elements(flagtable)
if numflag eq 0 then begin
	print,'***Error(FLAGBGDATA): zero number of flags!'
	return
endif
if checkdata([8,2,10]) ne 0 then return
;
index=where(bgscans.RateErr lt 0,count0)
;
for i=0,numflag-1 do begin
	j=where(abs(bgscans.Time) eq flagtable[i].time,count)
	if count gt 0 then begin
		ob=flagtable[i].outbeam
		ch=flagtable[i].channel
		case flagtable[i].item of
;
		19:begin
		   bgscans[j].Time=-flag*abs(bgscans[j].Time)
		   for ob=0,GenConfig.NumOutBeam-1 do begin
     		   for ch=0,GenConfig.NumSpecChan[ob]-1 do begin
		   bgscans[j].RateErr(ob,ch)= $
		  	-flag*abs(bgscans[j].RateErr(ob,ch))
		   endfor
		   endfor
		   end
		20:begin
		   bgscans[j].Time=-flag*abs(bgscans[j].Time)
		   for ob=0,GenConfig.NumOutBeam-1 do begin
     		   for ch=0,GenConfig.NumSpecChan[ob]-1 do begin
		   bgscans[j].RateErr(ob,ch)= $
		  	-flag*abs(bgscans[j].RateErr(ob,ch))
		   endfor
		   endfor
		   end
		21:bgscans[j].RateErr(ob,ch)= $
			-flag*abs(bgscans[j].RateErr(ob,ch))
		else:begin
   		   print,'***Error(FLAGBGDATA): item not allowed: ', $
			flagtable[i].item,'!'
     		   end
;
		endcase
	endif
endfor
;
index=where(bgscans.RateErr lt 0,count1)
;
print,'Editing complete:',count1-count0,' data points.'
end
