pro flaginchdata,flagtable,flag=flag
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Applies (flag=1) or removes (flag=-1) flags of flag table in metro data.
; Calls a C-program for faster execution.
;
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common InchData,Sol0,SolN,Jscan,MetroTime,FeedVector, $
        ParX,ParXErr,ParY,ParYErr,ParZ,ParZErr,MetroPath,MetroPathErr, $
	MotorAngle,MotorAngleErr
;
if not keyword_set(flag) then flag=1L else flag=long(flag)
if(flag ne 1) and (flag ne -1) then begin
	print,'***Error(FLAGMETRODATA): flag must be 1 (flag) or -1 (unflag)!'
	return
endif
;
numflag=n_elements(flagtable)
if numflag eq 0 then begin
	print,'***Error(FLAGMETRODATA): zero number of flags!'
	return
endif
if checkdata([8,16]) ne 0 then return
;
item=flagtable.item
inbeam=flagtable.inbeam
time=flagtable.time
;
numinbeam=GenConfig.NumSid
;
numpoint=n_elements(MetroTime)
;
flagged=0L
flagged=linknload(!external_lib,'flaginchdata',numflag,flag, $
	item,inbeam,time, $
	MetroTime,ParXErr,ParYErr,ParZErr,MetroPathErr,MotorAngleErr, $
	numinbeam,numpoint)
;
if flagged eq -1 then print,'***Error(FLAGMETRODATA): invalid item!' $
else begin
	print,'Editing complete:',flagged,' primary data points.'
	for i=0,GenConfig.NumSid-1 do begin
		index=where(ParXErr[i,*] gt 0,count)
		if count gt 0 then begin
			ParX[i,*]=ParX[i,*]-ParX[i,index[0]]
			ParY[i,*]=ParY[i,*]-ParY[i,index[0]]
			ParZ[i,*]=ParZ[i,*]-ParZ[i,index[0]]
		endif
	endfor
	print,'Re-referenced metro data.'
endelse
;
end
