pro flagphase,beams,baselines,channels=channels
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Flag specified channels in visphase. Default if undefined.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
;
if n_elements(beams) eq 0 then beems=indgen(GenConfig.NumOutBeam) $
			  else beems=beams-1
;
FOR i=0,n_elements(beems)-1 DO BEGIN
;
if beems[i] lt 0 or beems[i] ge GenConfig.NumOutBeam then begin
	print,'***Error(FLAGPHASE): invalid beam selection!'
	return
endif
;
; Get default channels first, then check for user input
chans=channelindex(genconfig.spectrometerid[beems[i]],/bad)-1
if n_elements(channels) gt 0 then begin
	s=size(channels)
	if s[0] le 1 then chans=channels[where(channels gt 0)]-1 $
		     else chans=channels[beems[i],where(channels[beems[i],*] $
						  gt 0)]-1
endif
if n_elements(baselines) eq 0 then bl=indgen(genconfig.numbaseline[beems[i]]) $
			      else bl=baselines-1
if min(chans) ge 0 then begin
visphaseerr[beems[i],chans,bl,*]=-abs(visphaseerr[beems[i],chans,bl,*])
;
print,'VisPhase flagged for channels '+retroparse(chans+1)+ $
      ' and baselines '+retroparse(bl+1)+ $
      ' in beam '+string(beems[i]+1,format='(i1)')+'.'
endif
;
ENDFOR
;
end
