pro flagpointdata,flagtable,flag=flag,ib=ib,ob=ob,tr=tr,ch=ch,bl=bl,pt=pt, $
	item=item,reason=reason,notable=notable
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Applies (flag=1) or removes (flag=-1) flags of flag table in point data.
; Calls a C-program for faster execution.
;
common DataSelInfo,class,type,slice,ds_nights,ds_stars,ds_x,ds_y,ds_z,ps_options
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
if checkdata([8,11]) ne 0 then return
;
if not keyword_set(flag) then flag=1L else flag=long(flag)
if(flag ne 1) and (flag ne -1) then begin
	print,'***Error(FLAGPOINTDATA): flag must be 1 (flag) or -1 (unflag)!'
	return
endif
;
numflag=n_elements(flagtable)
IF numflag EQ 0 THEN BEGIN
;
; Check flag table
if n_elements(pointflagtable) eq 0 then create_pointflagtable
index=where(pointflagtable.time ge 0,count)
id0=count
;
; Check pt
if not keyword_set(pt) then pt0=indgen(n_elements(PointTime)) $
else begin
index=intarr(n_elements(PointTime))
jndex=intarr(n_elements(PointTime))
for i=0,n_elements(pt)-1 do begin
	if pt[i] gt 0 then index[pt[i]-1]=1 else begin
		jndex[abs(pt[i])-1]=1
		index[where(jndex eq 0)]=1
		index[abs(pt[i])-1]=0
	endelse
endfor
pt0=where(index eq 1)
endelse
;
; Check ib
if not keyword_set(ib) then ib0=indgen(GenConfig.NumSid) $
		       else ib0=ib-1
; Check ob
if not keyword_set(ob) then ob0=indgen(GenConfig.NumOutBeam) $
		       else ob0=ob-1
;
; Check tr
if not keyword_set(tr) then tr0=indgen(GenConfig.NumTriple) $
		       else tr0=tr-1
; Check ch
if not keyword_set(ch) then ch=indgen(max(GenConfig.NumSpecChan))+1
ch0=intarr(n_elements(ob0),max(GenConfig.NumSpecChan))-1
for i=0,n_elements(ob0)-1 do begin
        s=size(ch)
        if s[0] le 1 then ch0[i,0:total(ch gt 0)-1] $
                         =ch[where(ch gt 0)]-1 $
                     else ch0[i,0:total(ch[ob0[i],*] gt 0)-1] $
                         =ch[ob0[i],where(ch[ob0[i],*] gt 0)]-1
endfor
;
; Check bl
if not keyword_set(bl) then bl=indgen(max(GenConfig.NumBaseline))+1
bl0=intarr(n_elements(ob0),max(GenConfig.NumBaseline))-1
for i=0,n_elements(ob0)-1 do begin
        s=size(bl)
        if s[0] le 1 then bl0[i,0:total(bl gt 0)-1] $
                         =bl[where(bl gt 0)]-1 $
                     else bl0[i,0:total(bl[ob0[i],*] gt 0)-1] $
                         =bl[ob0[i],where(bl[ob0[i],*] gt 0)]-1
endfor
;
; Check reason
if not keyword_set(reason) then reason=strmid(systime(),0,24)+' MANUAL'
;
; Check notable
if not keyword_set(notable) then notable=0
;
!qiet=1
fcount=0
for i=0,n_elements(ib0)-1 do begin
for j=0,n_elements(ob0)-1 do begin
for k=0,n_elements(tr0)-1 do begin
for l=0,n_elements(ch0[j,*])-1 do begin
for m=0,n_elements(bl0[j,*])-1 do begin
	case item of
	5:	begin
		if ch0[j,l] ge 0 and bl0[j,m] ge 0 then begin
		index=where(VisPhaseErr[ob0[j],ch0[j,l],bl0[j,m],pt0] gt 0,count)
		if count gt 0 then begin
			id=id0+count-1
		   	set_pointflagtable,reason,intarr(count)+item, $
				intarr(count),ob0[j],intarr(count), $
				ch0[j,l],bl0[j,m], $
				abs(PointTime[pt0[index]])
		endif
		endif
		end
	endcase
	if count gt 0 then begin
		flagpointdata,pointflagtable[id0:id],flag=flag
		if notable then pointflagtable[id0:id].time=-1 else id0=id
	endif
	fcount=fcount+count
endfor
endfor
endfor
endfor
endfor
;
print,'Editing complete:',fcount,' primary data points.'
!qiet=0
;
return
ENDIF
;
; Subscriptions to be flagged
item=flagtable.item
inbeam=flagtable.inbeam
outbeam=flagtable.outbeam
triple=flagtable.triple
baseline=flagtable.baseline
channel=flagtable.channel
time=flagtable.time
;
; Auxilliary information
stationid=GenConfig.StationId
baselineid=GenConfig.BaselineId
tripleOB=GenConfig.TripleBeam
tripleBl=GenConfig.TripleBase
tripleCh=GenConfig.TripleChan
tripleNumCh=GenConfig.TripleNumChan
;
; Loop information
numinbeam=GenConfig.NumSid
numoutbeam=GenConfig.NumOutBeam
numtriple=GenConfig.NumTriple
;
; Dimensioning information
maxtriple=n_elements(GenConfig.TripleChan)
maxtchannel=max(GenConfig.TripleNumChan)
maxbaseline=max(GenConfig.NumBaseline)
maxchannel=max(GenConfig.NumSpecChan)
;
numbaseline=GenConfig.NumBaseline
numchannel=GenConfig.NumSpecChan
numpoint=n_elements(PointTime)
;
flagged=0L
flagged=linknload(!external_lib,'flagpointdata',numflag,flag, $
	item,inbeam,outbeam,triple,baseline,channel,time, $
	PointTime,FDLPosErr,DelayJitterErr,NATJitterErr,NATCountsErr, $
	PhotonRateErr,VisSqErr, $
	VisAmpErr,VisPhaseErr,TripleAmpErr,TriplePhaseErr, $
	GrpDelayErr,DryDelayErr,WetDelayErr, $
	stationid,baselineid,tripleOB,tripleBl,tripleCh,tripleNumCh, $
	numinbeam,numoutbeam,numtriple,numbaseline,numchannel,numpoint, $
	maxtriple,maxtchannel,maxbaseline,maxchannel)
;
if flagged eq -1 then print,'***Error(FLAGPOINTDATA): invalid item!' $
else if not !qiet then print,'Editing complete:',flagged,' primary data points.'
;
end
