pro flagscandata,flagtable,flag=flag,ib=ib,ob=ob,tr=tr,ch=ch,bl=bl,sc=sc, $
	item=item,reason=reason
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Applies (flag=1) or removes (flag=-1) flags of flag table in scan data.
; Loops over all input vectors, or uses flagtable as list of flags to apply.
; Note: convention for input vectors is "1" for first element, while the
; flagtable, being internal, has "0" for the first element.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
if checkdata([8,9]) ne 0 then return
;
if not keyword_set(flag) then flag=1
if(flag ne 1L) and (flag ne -1L) then begin
	print,'***Error(FLAGSCANDATA): flag must be 1 (flag) or -1 (unflag)!'
	return
endif
;
numflag=n_elements(flagtable)
;
; Flag data given the indices passed
IF numflag EQ 0 THEN BEGIN
;
; Check flag table
if n_elements(scanflagtable) eq 0 then create_scanflagtable
index=where(scanflagtable.time ge 0,count)
id0=count
;
; Check sc
if not keyword_set(sc) then sc=indgen(n_elements(scans))+1
index=intarr(n_elements(scans))
jndex=intarr(n_elements(scans))
for i=0,n_elements(sc)-1 do begin
	if sc[i] gt 0 then index[sc[i]-1]=1 else begin
		jndex[abs(sc[i])-1]=1
		index[where(jndex eq 0)]=1
		index[abs(sc[i])-1]=0
	endelse
endfor
sc0=where(index eq 1)
;
; Check ib
if not keyword_set(ib) then ib0=indgen(GenConfig.NumSid) $
		       else ib0=ib-1
; Check ob
if not keyword_set(ob) then ob0=indgen(GenConfig.NumOutBeam) $
		       else ob0=ob-1
;
; Check tr
if not keyword_set(tr) then tr0=indgen(GenConfig.NumTriple > 1) $
		       else tr0=tr-1
; Check ch
if not keyword_set(ch) then ch=indgen(max(GenConfig.NumSpecChan))+1
ch0=intarr(n_elements(ob0),max(GenConfig.NumSpecChan))-1
for i=0,n_elements(ob0)-1 do begin
        s=size(ch)
        if s[0] le 1 then ch0[i,0:total(ch gt 0)-1] $
                         =ch[where(ch gt 0)]-1 $
                     else ch0[i,0:total(ch[ob0[i],*] gt 0)-1] $
                         =ch[ob0[i],where(ch[ob0[i],*] gt 0)]-1
endfor
;
; Check bl
if not keyword_set(bl) then bl=indgen(max(GenConfig.NumBaseline))+1
bl0=intarr(n_elements(ob0),max(GenConfig.NumBaseline))-1
for i=0,n_elements(ob0)-1 do begin
        s=size(bl)
        if s[0] le 1 then bl0[i,0:total(bl gt 0)-1] $
                         =bl[where(bl gt 0)]-1 $
                     else bl0[i,0:total(bl[ob0[i],*] gt 0)-1] $
                         =bl[ob0[i],where(bl[ob0[i],*] gt 0)]-1
endfor
;
; Check reason
if not keyword_set(reason) then reason=strmid(systime(),0,24)+' MANUAL'
;
!qiet=1
fcount=0
for i=0,n_elements(ib0)-1 do begin
for j=0,n_elements(ob0)-1 do begin
for k=0,n_elements(tr0)-1 do begin
for l=0,n_elements(ch0[j,*])-1 do begin
for m=0,n_elements(bl0[j,*])-1 do begin
	case item of
	24:	begin
		if ch0[j,l] ge 0 and bl0[j,m] ge 0 then begin
		index=where(scans[sc0].vissqerr(ob0[j],ch0[j,l],bl0[j,m]) gt 0,count)
		if count gt 0 then begin
			id=id0+count-1
			scanflagtable[id0:id].reason=reason
			scanflagtable[id0:id].item=24
			scanflagtable[id0:id].channel=ch0[j,l]
			scanflagtable[id0:id].baseline=bl0[j,m]
			scanflagtable[id0:id].outbeam=ob0[j]
			scanflagtable[id0:id].time=abs(scans[sc0[index]].time)
		endif
		endif else count=0
		end
	endcase
	if count gt 0 then begin
		flagscandata,scanflagtable[id0:id],flag=flag
		fcount=fcount+count
		id0=id+1
	endif
endfor
endfor
endfor
endfor
endfor
;
print,'Editing complete:',fcount,' primary data points.'
!qiet=0
;
return
ENDIF
;
; Flag data using the flagtable passed
fcount=0
;
FOR i=0,numflag-1 do BEGIN
;
; j=where(abs(scans(*).Time) eq flagtable(i).time,count)
;
; Now, we put times on grid before matching
ts=abs(scans[*].Time) & ts=nint(ts)/30*30.0
tf=flagtable[i].time & tf=nint(tf)/30*30.0
j=where(ts eq tf,count)
;
if count gt 0 then begin
  fcount=fcount+1
  ib=flagtable[i].inbeam
  ob=flagtable[i].outbeam
  tr=flagtable[i].triple
  ch=flagtable[i].channel
  bl=flagtable[i].baseline
  case flagtable[i].item of
;
  22:begin	; Time
;    scans(j).Time=-flag*abs(scans(j).Time)	; change V. 9.00
     scans[j].Int_Time=-flag*abs(scans[j].Int_Time)
     scans[j].VisSqErr=-flag*abs(scans[j].VisSqErr)
     scans[j].VisSqCErr=-flag*abs(scans[j].VisSqCErr)
     scans[j].VisSqEErr=-flag*abs(scans[j].VisSqEErr)
     scans[j].VisSqECErr=-flag*abs(scans[j].VisSqECErr)
     scans[j].PhotonRateErr=-flag*abs(scans[j].PhotonRateErr)
     scans[j].BackgndErr=-flag*abs(scans[j].BackgndErr)
     scans[j].TripleAmpErr=-flag*abs(scans[j].TripleAmpErr)
     scans[j].TripleAmpCErr=-flag*abs(scans[j].TripleAmpCErr)
     scans[j].TripleAmpEErr=-flag*abs(scans[j].TripleAmpEErr)
     scans[j].TripleAmpECErr=-flag*abs(scans[j].TripleAmpECErr)
     scans[j].TriplePhaseErr=-flag*abs(scans[j].TriplePhaseErr)
     scans[j].TriplePhaseCErr=-flag*abs(scans[j].TriplePhaseCErr)
     scans[j].FDLPosErr=-flag*abs(scans[j].FDLPosErr)
     scans[j].NATJitterErr=-flag*abs(scans[j].NATJitterErr)
     scans[j].GrpDelayErr=-flag*abs(scans[j].GrpDelayErr)
     scans[j].DryDelayErr=-flag*abs(scans[j].DryDelayErr)
     scans[j].WetDelayErr=-flag*abs(scans[j].WetDelayErr)
     scans[j].DelayJitterErr=-flag*abs(scans[j].DelayJitterErr)
     scans[j].PhotometryErr=-flag*abs(scans[j].PhotometryErr)
     scans[j].PhotometryCErr=-flag*abs(scans[j].PhotometryCErr)
     end
  23:begin	; Scan ID
;    scans(j).Time=-flag*abs(scans(j).Time)	; change V. 9.00
     scans[j].Int_Time=-flag*abs(scans[j].Int_Time)
     for ib=0,GenConfig.NumSid-1 do begin
     for ob=0,GenConfig.NumOutBeam-1 do begin
     for ch=0,GenConfig.NumSpecChan[ob]-1 do begin
          scans[j].PhotometryErr(ib,ob,ch)= $
		  -flag*abs(scans[j].PhotometryErr(ib,ob,ch))
	  scans[j].PhotometryCErr(ib,ob,ch)= $
		  -flag*abs(scans[j].PhotometryCErr(ib,ob,ch))
     endfor
     endfor
     endfor
     for ob=0,GenConfig.NumOutBeam-1 do begin
     for ch=0,GenConfig.NumSpecChan[ob]-1 do begin
       for bl=0,GenConfig.NumBaseline[ob]-1 do begin
          scans[j].VisSqErr(ob,ch,bl)=-flag*abs(scans[j].VisSqErr(ob,ch,bl))
	  scans[j].VisSqCErr(ob,ch,bl)=-flag*abs(scans[j].VisSqCErr(ob,ch,bl))
	  scans[j].VisSqEErr(ob,ch,bl)=-flag*abs(scans[j].VisSqEErr(ob,ch,bl))
	  scans[j].VisSqECErr(ob,ch,bl)=-flag*abs(scans[j].VisSqECErr(ob,ch,bl))
       endfor
       scans[j].PhotonRateErr(ob,ch)=-flag*abs(scans[j].PhotonRateErr(ob,ch))
       scans[j].BackgndErr(ob,ch)=-flag*abs(scans[j].BackgndErr(ob,ch))
     endfor
     endfor
     for tr=0,GenConfig.NumTriple-1 do begin
     for ch=0,GenConfig.TripleNumChan[tr]-1 do begin
	scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
	scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
	scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
	scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch))
	scans[j].TriplePhaseErr(tr,ch)=-flag*abs(scans[j].TriplePhaseErr(tr,ch))
	scans[j].TriplePhaseCErr(tr,ch)=-flag*abs(scans[j].TriplePhaseCErr(tr,ch))
     endfor
     endfor
     for ib=0,GenConfig.NumSid-1 do begin
       scans[j].FDLPosErr(ib)=-flag*abs(scans[j].FDLPosErr(ib))
       scans[j].NATJitterErr(ib)=-flag*abs(scans[j].NATJitterErr(ib))
       scans[j].GrpDelayErr(ib)=-flag*abs(scans[j].GrpDelayErr(ib))
       scans[j].DryDelayErr(ib)=-flag*abs(scans[j].DryDelayErr(ib))
       scans[j].WetDelayErr(ib)=-flag*abs(scans[j].WetDelayErr(ib))
     endfor
     for ob=0,GenConfig.NumOutBeam-1 do begin
     for bl=0,GenConfig.NumBaseline[ob]-1 do begin
        scans[j].DelayJitterErr(ob,bl)=-flag*abs(scans[j].DelayJitterErr(ob,bl))
     endfor
     endfor
     end
  24:begin	; VisSq
     scans[j].VisSqErr(ob,ch,bl)=-flag*abs(scans[j].VisSqErr(ob,ch,bl))
     scans[j].VisSqCErr(ob,ch,bl)=-flag*abs(scans[j].VisSqCErr(ob,ch,bl))
     scans[j].VisSqEErr(ob,ch,bl)=-flag*abs(scans[j].VisSqEErr(ob,ch,bl))
     scans[j].VisSqECErr(ob,ch,bl)=-flag*abs(scans[j].VisSqECErr(ob,ch,bl))
     for tr=0,GenConfig.NumTriple-1 do begin
     for l=0,2 do begin
       if (GenConfig.TripleBase[l,tr] eq bl) and $
	  (GenConfig.TripleBeam[l,tr] eq ob) then begin
	 k=where(GenConfig.TripleChan[0:GenConfig.TripleNumChan[tr]-1,l,tr] $
	     eq ch,count)
	 not_l=where(indgen(3) ne l)
	 not_ob=GenConfig.TripleBeam[not_l,tr]
	 not_bl=GenConfig.TripleBase[not_l,tr]
         kk=[k,k]
	 if count gt 0 then begin
	  if flag eq 1 $
          or (flag eq -1 $
          and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
           scans[j].TripleAmpErr(tr,k)=-flag*abs(scans[j].TripleAmpErr(tr,k))
           scans[j].TripleAmpCErr(tr,k)=-flag*abs(scans[j].TripleAmpCErr(tr,k))
           scans[j].TripleAmpEErr(tr,k)=-flag*abs(scans[j].TripleAmpEErr(tr,k))
           scans[j].TripleAmpECErr(tr,k)=-flag*abs(scans[j].TripleAmpECErr(tr,k)
           scans[j].TriplePhaseErr(tr,k)=-flag*abs(scans[j].TriplePhaseErr(tr,k)
           scans[j].TriplePhaseCErr(tr,k)=-flag*abs(scans[j].TriplePhaseCErr(tr,
	  endif
         endif
       endif
     endfor
     endfor
     end
  25:begin	; VisSq C
     scans[j].VisSqErr(ob,ch,bl)=-flag*abs(scans[j].VisSqErr(ob,ch,bl))
     scans[j].VisSqCErr(ob,ch,bl)=-flag*abs(scans[j].VisSqCErr(ob,ch,bl))
     scans[j].VisSqEErr(ob,ch,bl)=-flag*abs(scans[j].VisSqEErr(ob,ch,bl))
     scans[j].VisSqECErr(ob,ch,bl)=-flag*abs(scans[j].VisSqECErr(ob,ch,bl))
     for tr=0,GenConfig.NumTriple-1 do begin
     for l=0,2 do begin
       if (GenConfig.TripleBase[l,tr] eq bl) and $
	  (GenConfig.TripleBeam[l,tr] eq ob) then begin
	 k=where(GenConfig.TripleChan[0:GenConfig.TripleNumChan[tr]-1,l,tr] eq ch,count
	 not_l=where(indgen(3) ne l)
	 not_ob=GenConfig.TripleBeam[not_l,tr]
	 not_bl=GenConfig.TripleBase[not_l,tr]
         kk=[k,k]
	 if count gt 0 then begin
	  if flag eq 1 $
          or (flag eq -1 $
          and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
           scans[j].TripleAmpErr(tr,k)=-flag*abs(scans[j].TripleAmpErr(tr,k))
           scans[j].TripleAmpCErr(tr,k)=-flag*abs(scans[j].TripleAmpCErr(tr,k))
           scans[j].TripleAmpEErr(tr,k)=-flag*abs(scans[j].TripleAmpEErr(tr,k))
           scans[j].TripleAmpECErr(tr,k)=-flag*abs(scans[j].TripleAmpECErr(tr,k)
           scans[j].TriplePhaseErr(tr,k)=-flag*abs(scans[j].TriplePhaseErr(tr,k)
           scans[j].TriplePhaseCErr(tr,k)=-flag*abs(scans[j].TriplePhaseCErr(tr,
	  endif
         endif
       endif
     endfor
     endfor
     end
  26:begin	; VisSq/e
     scans[j].VisSqErr(ob,ch,bl)=-flag*abs(scans[j].VisSqErr(ob,ch,bl))
     scans[j].VisSqCErr(ob,ch,bl)=-flag*abs(scans[j].VisSqCErr(ob,ch,bl))
     scans[j].VisSqEErr(ob,ch,bl)=-flag*abs(scans[j].VisSqEErr(ob,ch,bl))
     scans[j].VisSqECErr(ob,ch,bl)=-flag*abs(scans[j].VisSqECErr(ob,ch,bl))
     for tr=0,GenConfig.NumTriple-1 do begin
     for l=0,2 do begin
       if (GenConfig.TripleBase[l,tr] eq bl) and $
	  (GenConfig.TripleBeam[l,tr] eq ob) then begin
	 k=where(GenConfig.TripleChan[0:GenConfig.TripleNumChan[tr]-1,l,tr] eq ch,count
	 not_l=where(indgen(3) ne l)
	 not_ob=GenConfig.TripleBeam[not_l,tr]
	 not_bl=GenConfig.TripleBase[not_l,tr]
         kk=[k,k]
	 if count gt 0 then begin
	  if flag eq 1 $
          or (flag eq -1 $
          and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
           scans[j].TripleAmpErr(tr,k)=-flag*abs(scans[j].TripleAmpErr(tr,k))
           scans[j].TripleAmpCErr(tr,k)=-flag*abs(scans[j].TripleAmpCErr(tr,k))
           scans[j].TripleAmpEErr(tr,k)=-flag*abs(scans[j].TripleAmpEErr(tr,k))
           scans[j].TripleAmpECErr(tr,k)=-flag*abs(scans[j].TripleAmpECErr(tr,k)
           scans[j].TriplePhaseErr(tr,k)=-flag*abs(scans[j].TriplePhaseErr(tr,k)
           scans[j].TriplePhaseCErr(tr,k)=-flag*abs(scans[j].TriplePhaseCErr(tr,
	  endif
         endif
       endif
     endfor
     endfor
     end
  27:begin	; VisSq c/e
     scans[j].VisSqErr(ob,ch,bl)=-flag*abs(scans[j].VisSqErr(ob,ch,bl))
     scans[j].VisSqCErr(ob,ch,bl)=-flag*abs(scans[j].VisSqCErr(ob,ch,bl))
     scans[j].VisSqEErr(ob,ch,bl)=-flag*abs(scans[j].VisSqEErr(ob,ch,bl))
     scans[j].VisSqECErr(ob,ch,bl)=-flag*abs(scans[j].VisSqECErr(ob,ch,bl))
     for tr=0,GenConfig.NumTriple-1 do begin
     for l=0,2 do begin
       if (GenConfig.TripleBase[l,tr] eq bl) and $
	  (GenConfig.TripleBeam[l,tr] eq ob) then begin
	 k=where(GenConfig.TripleChan[0:GenConfig.TripleNumChan[tr]-1,l,tr] eq ch,count
	 not_l=where(indgen(3) ne l)
	 not_ob=GenConfig.TripleBeam[not_l,tr]
	 not_bl=GenConfig.TripleBase[not_l,tr]
         kk=[k,k]
	 if count gt 0 then begin
	  if flag eq 1 $
          or (flag eq -1 $
          and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
           scans[j].TripleAmpErr(tr,k)=-flag*abs(scans[j].TripleAmpErr(tr,k))
           scans[j].TripleAmpCErr(tr,k)=-flag*abs(scans[j].TripleAmpCErr(tr,k))
           scans[j].TripleAmpEErr(tr,k)=-flag*abs(scans[j].TripleAmpEErr(tr,k))
           scans[j].TripleAmpECErr(tr,k)=-flag*abs(scans[j].TripleAmpECErr(tr,k)
           scans[j].TriplePhaseErr(tr,k)=-flag*abs(scans[j].TriplePhaseErr(tr,k)
           scans[j].TriplePhaseCErr(tr,k)=-flag*abs(scans[j].TriplePhaseCErr(tr,
	  endif
         endif
       endif
     endfor
     endfor
     end
  28:begin	; TripleAmp
     scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
     scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
     scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
     scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch))
     end
  29:begin	; TripleAmp c
     scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
     scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
     scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
     scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch))
     end
  30:begin	; TripleAmp/e
     scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
     scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
     scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
     scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch))
     end
  31:begin	; TripleAmp c/e
     scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
     scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
     scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
     scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch))
     end
  32:begin	; TriplePhase
     scans[j].TriplePhaseErr(tr,ch)=-flag*abs(scans[j].TriplePhaseErr(tr,ch))
     scans[j].TriplePhaseCErr(tr,ch)=-flag*abs(scans[j].TriplePhaseCErr(tr,ch))
     end
  33:begin	; TriplePhase c
     scans[j].TriplePhaseErr(tr,ch)=-flag*abs(scans[j].TriplePhaseErr(tr,ch))
     scans[j].TriplePhaseCErr(tr,ch)=-flag*abs(scans[j].TriplePhaseCErr(tr,ch))
     end
  34:begin
;    Photonrate
     scans[j].PhotonRateErr(ob,ch)=-flag*abs(scans[j].PhotonRateErr(ob,ch))
     scans[j].VisSqErr(ob,ch,*)=-flag*abs(scans[j].VisSqErr(ob,ch,*))
     scans[j].VisSqCErr(ob,ch,*)=-flag*abs(scans[j].VisSqCErr(ob,ch,*))
     scans[j].VisSqEErr(ob,ch,*)=-flag*abs(scans[j].VisSqEErr(ob,ch,*))
     scans[j].VisSqECErr(ob,ch,*)=-flag*abs(scans[j].VisSqECErr(ob,ch,*))
     for tr=0,GenConfig.NumTriple-1 do begin
     for l=0,2 do begin
       if (GenConfig.TripleBeam[l,tr] eq ob) then begin
	 k=where(GenConfig.TripleChan[0:GenConfig.TripleNumChan[tr]-1,l,tr] eq ch,count
	 not_l=where(indgen(3) ne l)
	 not_ob=GenConfig.TripleBeam[not_l,tr]
	 not_bl=GenConfig.TripleBase[not_l,tr]
         kk=[k,k]
	 if count gt 0 then begin
	  if flag eq 1 $
          or (flag eq -1 $
          and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
           scans[j].TripleAmpErr(tr,k)=-flag*abs(scans[j].TripleAmpErr(tr,k))
           scans[j].TripleAmpCErr(tr,k)=-flag*abs(scans[j].TripleAmpCErr(tr,k))
           scans[j].TripleAmpEErr(tr,k)=-flag*abs(scans[j].TripleAmpEErr(tr,k))
           scans[j].TripleAmpECErr(tr,k)=-flag*abs(scans[j].TripleAmpECErr(tr,k)
           scans[j].TriplePhaseErr(tr,k)=-flag*abs(scans[j].TriplePhaseErr(tr,k)
           scans[j].TriplePhaseCErr(tr,k)=-flag*abs(scans[j].TriplePhaseCErr(tr,
	  endif
	 endif
       endif
     endfor
     endfor
     end
  36:begin
;    FDLPath
     scans[j].FDLPosErr(ib)=-flag*abs(scans[j].FDLPosErr(ib))
     for ob=0,GenConfig.NumOutBeam-1 do begin
     for bl=0,GenConfig.NumBaseline[ob]-1 do begin
       if strpos(GenConfig.BaselineId[bl,ob],GenConfig.StationId[ib]) ne -1 $
		then begin
         scans[j].DelayJitterErr(ob,bl)=-flag*abs(scans[j].DelayJitterErr(ob,bl)
	 scans[j].VisSqErr(ob,*,bl)=-flag*abs(scans[j].VisSqErr(ob,*,bl))
         scans[j].VisSqCErr(ob,*,bl)=-flag*abs(scans[j].VisSqCErr(ob,*,bl))
         scans[j].VisSqEErr(ob,*,bl)=-flag*abs(scans[j].VisSqEErr(ob,*,bl))
         scans[j].VisSqECErr(ob,*,bl)=-flag*abs(scans[j].VisSqECErr(ob,*,bl))
       endif
     endfor
     endfor
     for tr=0,GenConfig.NumTriple-1 do begin
     for l=0,2 do begin
       m=GenConfig.TripleBase[l,tr]
       n=GenConfig.TripleBeam[l,tr]
       if strpos(GenConfig.BaselineId[m,n],GenConfig.StationId[ib]) ne -1 $
	  							  then begin
       not_l=where(indgen(3) ne l)
       not_ob=GenConfig.TripleBeam[not_l,tr]
       not_bl=GenConfig.TripleBase[not_l,tr]
       for ch=0,GenConfig.TripleNumChan[tr]-1 do begin
	k=GenConfig.TripleChan[ch,l,tr]
        kk=[k,k]
	if flag eq 1 $
        or (flag eq -1 $
        and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
	 scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
	 scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
	 scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
	 scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch))
         scans[j].TriplePhaseErr(tr,ch)=-flag*abs(scans[j].TriplePhaseErr(tr,ch)
         scans[j].TriplePhaseCErr(tr,ch)=-flag*abs(scans[j].TriplePhaseCErr(tr,c
	endif
       endfor
       endif
     endfor
     endfor
     end
  37:begin
;    DelayJitter
     baseline=GenConfig.BaselineId[bl,ob]
     station1=strmid(baseline,0,3)
     station2=strmid(baseline,4,3)
     for ob=0,GenConfig.NumOutBeam-1 do begin
     for bl=0,GenConfig.NumBaseline[ob]-1 do begin
      if (strpos(GenConfig.BaselineId[bl,ob],station1) ne -1) and $
	 (strpos(GenConfig.BaselineId[bl,ob],station2) ne -1) then begin
       scans[j].DelayJitterErr(ob,bl)=-flag*abs(scans[j].DelayJitterErr(ob,bl))
       scans[j].VisSqErr(ob,*,bl)=-flag*abs(scans[j].VisSqErr(ob,*,bl))
       scans[j].VisSqCErr(ob,*,bl)=-flag*abs(scans[j].VisSqCErr(ob,*,bl))
       scans[j].VisSqEErr(ob,*,bl)=-flag*abs(scans[j].VisSqEErr(ob,*,bl))
       scans[j].VisSqECErr(ob,*,bl)=-flag*abs(scans[j].VisSqECErr(ob,*,bl))
      endif
      for tr=0,GenConfig.NumTriple-1 do begin
      for l=0,2 do begin
       if (GenConfig.TripleBase[l,tr] eq bl) and $
	  (GenConfig.TripleBeam[l,tr] eq ob) then begin
        not_l=where(indgen(3) ne l)
        not_ob=GenConfig.TripleBeam[not_l,tr]
        not_bl=GenConfig.TripleBase[not_l,tr]
        for ch=0,GenConfig.TripleNumChan[tr]-1 do begin
	 k=GenConfig.TripleChan[ch,l,tr]
         kk=[k,k]
	 if flag eq 1 $
         or (flag eq -1 $
         and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
          scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
          scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
          scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
          scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch
          scans[j].TriplePhaseErr(tr,ch)=-flag*abs(scans[j].TriplePhaseErr(tr,ch
          scans[j].TriplePhaseCErr(tr,ch)=-flag*abs(scans[j].TriplePhaseCErr(tr,
	 endif
	endfor
       endif
      endfor
      endfor
     endfor
     endfor
     end
  38:begin
;    NATJitter
     baseline=GenConfig.BaselineId[bl,ob]
     station1=strmid(baseline,0,3)
     station2=strmid(baseline,4,3)
     scans[j].NATJitterErr(where(GenConfig.StationId eq station1))= $
      -flag*abs(scans[j].NATJitterErr(where(GenConfig.StationId eq station1)))
     scans[j].NATJitterErr(where(GenConfig.StationId eq station2))= $
      -flag*abs(scans[j].NATJitterErr(where(GenConfig.StationId eq station2)))
     for ob=0,GenConfig.NumOutBeam-1 do begin
     for bl=0,GenConfig.NumBaseline[ob]-1 do begin
      if (strpos(GenConfig.BaselineId[bl,ob],station1) ne -1) and $
	 (strpos(GenConfig.BaselineId[bl,ob],station2) ne -1) then begin
       scans[j].VisSqErr(ob,*,bl)=-flag*abs(scans[j].VisSqErr(ob,*,bl))
       scans[j].VisSqCErr(ob,*,bl)=-flag*abs(scans[j].VisSqCErr(ob,*,bl))
       scans[j].VisSqEErr(ob,*,bl)=-flag*abs(scans[j].VisSqEErr(ob,*,bl))
       scans[j].VisSqECErr(ob,*,bl)=-flag*abs(scans[j].VisSqECErr(ob,*,bl))
      endif
      for tr=0,GenConfig.NumTriple-1 do begin
      for l=0,2 do begin
       if (GenConfig.TripleBase[l,tr] eq bl) and $
	  (GenConfig.TripleBeam[l,tr] eq ob) then begin
        not_l=where(indgen(3) ne l)
        not_ob=GenConfig.TripleBeam[not_l,tr]
        not_bl=GenConfig.TripleBase[not_l,tr]
        for ch=0,GenConfig.TripleNumChan[tr]-1 do begin
	 k=GenConfig.TripleChan[ch,l,tr]
         kk=[k,k]
	 if flag eq 1 $
         or (flag eq -1 $
         and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
          scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
          scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
          scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
          scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch
          scans[j].TriplePhaseErr(tr,ch)=-flag*abs(scans[j].TriplePhaseErr(tr,ch
          scans[j].TriplePhaseCErr(tr,ch)=-flag*abs(scans[j].TriplePhaseCErr(tr,
	 endif
	endfor
       endif
      endfor
      endfor
     endfor
     endfor
     end
  39:begin
;    FDLDelay
     scans[j].FDLPosErr(ib)=-flag*abs(scans[j].FDLPosErr(ib))
     scans[j].GrpDelayErr(ib)=-flag*abs(scans[j].GrpDelayErr(ib))
     scans[j].DryDelayErr(ib)=-flag*abs(scans[j].DryDelayErr(ib))
     scans[j].WetDelayErr(ib)=-flag*abs(scans[j].WetDelayErr(ib))
     for ob=0,GenConfig.NumOutBeam-1 do begin
     for bl=0,GenConfig.NumBaseline[ob]-1 do begin
       if strpos(GenConfig.BaselineId[bl,ob],GenConfig.StationId[ib]) ne -1 $
		then begin
         scans[j].DelayJitterErr(ob,bl)=-flag*abs(scans[j].DelayJitterErr(ob,bl)
	 scans[j].VisSqErr(ob,*,bl)=-flag*abs(scans[j].VisSqErr(ob,*,bl))
         scans[j].VisSqCErr(ob,*,bl)=-flag*abs(scans[j].VisSqCErr(ob,*,bl))
         scans[j].VisSqEErr(ob,*,bl)=-flag*abs(scans[j].VisSqEErr(ob,*,bl))
         scans[j].VisSqECErr(ob,*,bl)=-flag*abs(scans[j].VisSqECErr(ob,*,bl))
       endif
     endfor
     endfor
     for tr=0,GenConfig.NumTriple-1 do begin
     for bl=0,2 do begin
       m=GenConfig.TripleBase[bl,tr]
       n=GenConfig.TripleBeam[bl,tr]
       if strpos(GenConfig.BaselineId[m,n],GenConfig.StationId[ib]) ne -1 $
	  							  then begin
       not_l=where(indgen(3) ne bl)
       not_ob=GenConfig.TripleBeam[not_l,tr]
       not_bl=GenConfig.TripleBase[not_l,tr]
       for ch=0,GenConfig.TripleNumChan[tr]-1 do begin
	k=GenConfig.TripleChan[ch,bl,tr]
        kk=[k,k]
	if flag eq 1 $
        or (flag eq -1 $
        and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
	 scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
	 scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
	 scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
	 scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch))
         scans[j].TriplePhaseErr(tr,ch)=-flag*abs(scans[j].TriplePhaseErr(tr,ch)
         scans[j].TriplePhaseCErr(tr,ch)=-flag*abs(scans[j].TriplePhaseCErr(tr,c
	endif
       endfor
       endif
     endfor
     endfor
     end
  53:begin
;    FDL_O-C
     scans[j].FDLPosErr(ib)=-flag*abs(scans[j].FDLPosErr(ib))
     scans[j].GrpDelayErr(ib)=-flag*abs(scans[j].GrpDelayErr(ib))
     scans[j].DryDelayErr(ib)=-flag*abs(scans[j].DryDelayErr(ib))
     scans[j].WetDelayErr(ib)=-flag*abs(scans[j].WetDelayErr(ib))
     for ob=0,GenConfig.NumOutBeam-1 do begin
     for bl=0,GenConfig.NumBaseline[ob]-1 do begin
       if strpos(GenConfig.BaselineId[bl,ob],GenConfig.StationId[ib]) ne -1 $
		then begin
         scans[j].DelayJitterErr(ob,bl)=-flag*abs(scans[j].DelayJitterErr(ob,bl)
	 scans[j].VisSqErr(ob,*,bl)=-flag*abs(scans[j].VisSqErr(ob,*,bl))
         scans[j].VisSqCErr(ob,*,bl)=-flag*abs(scans[j].VisSqCErr(ob,*,bl))
         scans[j].VisSqEErr(ob,*,bl)=-flag*abs(scans[j].VisSqEErr(ob,*,bl))
         scans[j].VisSqECErr(ob,*,bl)=-flag*abs(scans[j].VisSqECErr(ob,*,bl))
       endif
     endfor
     endfor
     for tr=0,GenConfig.NumTriple-1 do begin
     for bl=0,2 do begin
       m=GenConfig.TripleBase[bl,tr]
       n=GenConfig.TripleBeam[bl,tr]
       if strpos(GenConfig.BaselineId[m,n],GenConfig.StationId[ib]) ne -1 $
	  							  then begin
       not_l=where(indgen(3) ne bl)
       not_ob=GenConfig.TripleBeam[not_l,tr]
       not_bl=GenConfig.TripleBase[not_l,tr]
       for ch=0,GenConfig.TripleNumChan[tr]-1 do begin
	k=GenConfig.TripleChan[ch,bl,tr]
        kk=[k,k]
	if flag eq 1 $
        or (flag eq -1 $
        and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
	 scans[j].TripleAmpErr(tr,ch)=-flag*abs(scans[j].TripleAmpErr(tr,ch))
	 scans[j].TripleAmpCErr(tr,ch)=-flag*abs(scans[j].TripleAmpCErr(tr,ch))
	 scans[j].TripleAmpEErr(tr,ch)=-flag*abs(scans[j].TripleAmpEErr(tr,ch))
	 scans[j].TripleAmpECErr(tr,ch)=-flag*abs(scans[j].TripleAmpECErr(tr,ch))
         scans[j].TriplePhaseErr(tr,ch)=-flag*abs(scans[j].TriplePhaseErr(tr,ch)
         scans[j].TriplePhaseCErr(tr,ch)=-flag*abs(scans[j].TriplePhaseCErr(tr,c
	endif
       endfor
       endif
     endfor
     endfor
     end
  54:scans[j].GrpDelayErr(ib)=-flag*abs(scans[j].GrpDelayErr(ib))
  55:scans[j].DryDelayErr(ib)=-flag*abs(scans[j].DryDelayErr(ib))
  56:scans[j].WetDelayErr(ib)=-flag*abs(scans[j].WetDelayErr(ib))
  94:begin
;    Photometry
     scans[j].PhotometryErr(ib,ob,ch)=-flag*abs(scans[j].PhotometryErr(ib,ob,ch)
     scans[j].PhotometryCErr(ib,ob,ch)=-flag*abs(scans[j].PhotometryCErr(ib,ob,c
     scans[j].PhotonRateErr(ob,ch)=-flag*abs(scans[j].PhotonRateErr(ob,ch))
     for bl=0,GenConfig.NumBaseline[ob]-1 do begin
       if strpos(GenConfig.BaselineId[bl,ob],GenConfig.StationId[ib]) ne -1 $
		then begin
	 scans[j].VisSqErr(ob,ch,bl)=-flag*abs(scans[j].VisSqErr(ob,ch,bl))
         scans[j].VisSqCErr(ob,ch,bl)=-flag*abs(scans[j].VisSqCErr(ob,ch,bl))
         scans[j].VisSqEErr(ob,ch,bl)=-flag*abs(scans[j].VisSqEErr(ob,ch,bl))
         scans[j].VisSqECErr(ob,ch,bl)=-flag*abs(scans[j].VisSqECErr(ob,ch,bl))
       endif
     endfor
     for tr=0,GenConfig.NumTriple-1 do begin
      for l=0,2 do begin
       m=GenConfig.TripleBase[l,tr]
       n=GenConfig.TripleBeam[l,tr]
       if strpos(GenConfig.BaselineId[m,n],GenConfig.StationId[ib]) ne -1 $
	  							  then begin
       k=where(GenConfig.TripleChan[0:GenConfig.TripleNumChan[tr]-1,l,tr] eq ch,
       not_l=where(indgen(3) ne l)
       not_ob=GenConfig.TripleBeam[not_l,tr]
       not_bl=GenConfig.TripleBase[not_l,tr]
       kk=[k,k]
       if count gt 0 then begin
	if flag eq 1 $
        or (flag eq -1 $
        and produkt(scans[j].VisSqErr(not_ob,kk,not_bl) gt 0) ne 0) then begin
	 scans[j].TripleAmpErr(tr,k)=-flag*abs(scans[j].TripleAmpErr(tr,k))
	 scans[j].TripleAmpCErr(tr,k)=-flag*abs(scans[j].TripleAmpCErr(tr,k))
	 scans[j].TripleAmpEErr(tr,k)=-flag*abs(scans[j].TripleAmpEErr(tr,k))
	 scans[j].TripleAmpECErr(tr,k)=-flag*abs(scans[j].TripleAmpECErr(tr,k))
         scans[j].TriplePhaseErr(tr,k)=-flag*abs(scans[j].TriplePhaseErr(tr,k))
         scans[j].TriplePhaseCErr(tr,k)=-flag*abs(scans[j].TriplePhaseCErr(tr,k)
	endif
       endif
       endif
      endfor
     endfor
     end
else:begin
     print,'***Error(FLAGSCANDATA): item not allowed: ',flagtable[i].item,'!'
     fcount=fcount-1
     end
  endcase
endif
ENDFOR
;
if not !qiet then print,'Editing complete:',fcount,' primary data points.'
;
; Overwrite copy of data in AMOEBA buffer
if n_elements(bufferinfo) gt 1 then $
storenight,11
;
end
