pro flagstars,starids,unflag=unflag
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Flag all (calibrated) data for the specified star(s).
; Note that this operation is not perfectly reversible.
; If keyword unflag is set, remove all flags.
;
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if not keyword_set(unflag) then unflag=1
;
for i=0,n_elements(starids)-1 do begin
;
index=where(scans.starid eq starids[i] or scans.star eq starids[i],count)
if count gt 0 then begin
	scans[index].vissqerr=-abs(scans[index].vissqcerr)*unflag
	scans[index].vissqcerr=-abs(scans[index].vissqcerr)*unflag
	scans[index].vissqecerr=-abs(scans[index].vissqcerr)*unflag
	scans[index].tripleamperr=-abs(scans[index].tripleampcerr)*unflag
	scans[index].tripleampcerr=-abs(scans[index].tripleampcerr)*unflag
	scans[index].tripleampecerr=-abs(scans[index].tripleampecerr)*unflag
	scans[index].triplephaseerr=-abs(scans[index].triplephasecerr)*unflag
	scans[index].triplephasecerr=-abs(scans[index].triplephasecerr)*unflag
endif
;
endfor
;
end
