pro flagstations,limit
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Check the natcounts and decide which station was likely off
; source. Enter the results in the scantable.station field and
; flag the relevant data. This procedure replaces the cumbersome
; manual data entry in fixconfiguration.
;
; If NAT data were not processed, this procedure will not edit.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common FlagTables,pointflagtable,inchflagtable,bgflagtable,scanflagtable
;
if n_elements(limit) eq 0 then limit=10
;
; If all natcounts are zero, then the corresponding data were not processed
if n_elements(natcounts) eq 0 then return
if max(natcounts) eq 0 then return
;
if n_elements(pointflagtable) eq 0 then begin
	create_pointflagtable
	count_station=0
endif else begin
	index=where(strpos(pointflagtable.reason,'STATION_AUTO') ge 0, $
			count_station)
	if count_station gt 0 then begin
;		The flagtable already has the corresponding entries
		flagpointdata,pointflagtable[index],flag=1
	endif
endelse
if count_station eq 0 then begin
	index=where(pointflagtable.time ge 0,count)
	id0=count
	id=id0
	reason=strmid(systime(),0,24)+' STATION_AUTO'
endif
;
for i=0,n_elements(scantable)-1 do begin
for j=0,genconfig.numsid-1 do begin
	if median(natcounts[j,rec0[i]:recn[i]]) lt limit then begin
		scantable[i].station(j)=0
		n=recn[i]-rec0[i]+1
		k=lonarr(n)
		item=k+11	; Use NATJitter to avoid flagging photonrate
		inbeam=k+j
		if count_station eq 0 then begin
		set_pointflagtable,reason,item,inbeam, $
			k,k,k,k,abs(pointtime[rec0[i]:recn[i]])
		id=id+n
		endif
	endif
endfor
endfor
; Set code to zero for scans without any light on the detectors (natcounts)
index=where(total(scantable.station[0:genconfig.numsid-1],1) eq 0 and $
		  scantable.code eq 1,count)
if count gt 0 then scantable[index].code=0
;
if count_station eq 0 then begin
if id gt id0 then flagpointdata,pointflagtable[id0:id-1],flag=1 $
	     else print,'No data flagged.'
endif
;
end
