function fluxband,teff,logg,clambda,dlambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Average stellar flux over rectangular band pass
; defined through center wavelength clambda [nm] and full width dlambda [nm].
;
if limbgrid(teff,logg,lammda,limbdu,fluxes) ne 0 then return,-1
;
num=n_elements(lammda)
tm=fltarr(num)
;
n=n_elements(clambda)
flux=fltarr(n)+1
for i=0,n-1 do begin
	index=where(abs(lammda-clambda[i]) lt dlambda[i]/2,count)
	if count gt 0 then tm[index]=1
	if total(tm) ne 0 then flux[i]=total(tm*fluxes)/total(tm)
	tm=tm*0
endfor
;
return,flux
;
end
