function fluxnpoi,teff,logg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return array of integrated stellar fluxes for the
; channels in GenConfig.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(GenConfig) eq 0 then begin
	print,'***Error(FLUXNPOI): GenConfig undefined!'
	return,-1
endif
;
if limbgrid(teff,logg,lammda,limbdu,fluxes) ne 0 then return,-1
;
tf=fltarr(max(GenConfig.NumSpecChan),GenConfig.NumOutBeam)
for i=0,GenConfig.NumOutBeam-1 do begin
for j=0,GenConfig.NumSpecChan[i]-1 do begin
	tm=generic_c(lammda,i,j)
	tf[j,i]=total(tm*fluxes)/total(tm)
endfor
endfor
;
return,tf
;
end
