function fried_r0,l,a,s
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute Fried's parameter r0[m] for wavelength l and airmass a, given zenith
; seeing s["] at 500 nm.
;
l0=500e-9	; DIMM wavelength [m]
; if s_in eq 0 then s=1.0
s_rad=(s/3600)*!pi/180
;
return,0.976*(l0/s_rad)*(l/l0)^1.2*a^(-0.6)
;
end
