function fringedelay,v,l,f,t,gindex,wrap=wrap
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function returns a delay which is usable for coherent
; integration of visibilities. This involves white light phase
; tracking on the corrected fringe phases returned by function
; "fringephase".
;
; l: lambda [m]
; f: residual laser delay [m]
; t: time [s]
;
if n_elements(wrap) eq 0 then wrap=0 else wrap=wrap gt 0
v=reform(temporary(v))
;
p2d=lambdawhite(v,l)/(2*!pi)
;
if n_params() eq 5 then d=trackdelay(v,l,f,p,t,gindex,wrap=wrap) $
		   else d=trackdelay(v,l,f,p,t,wrap=wrap)
return,d-p*p2d
;
end
