function fringedelays,baseline,beam,scanfile,channels=channels,gindex=gindex
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute and return fringe delays for specified baseline.
; (To compute total atmospheric delays, calculate fdl-fringedelay!)
; Must have used get_rawdata first!
; If scanfile defined, compute and concatenate for all sub-scans.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(scanfile) ne 0 then scanfiles=file_search(scanfile+'.??') $
			     else scanfiles=''
;
if n_elements(beam) eq 0 then beam=OutputBeam $
			 else if n_elements(scanfile) eq 0 $
			 	then get_bincounts,beam
ob=beam-1
bl=baseline-1
if n_elements(channels) eq 0 then $
	channels=channelindex[genconfig.spectrometerid[ob]]
ch=channels-1
if keyword_set(gindex) then classic=0 else classic=1
;
f=fdldelay(genconfig.baselineid[bl,ob],scan=n_elements(scanfile))
delays=fltarr(n_elements(f))
gindex=delays*0
;
wrap=0
;
for i=0,n_elements(scanfiles)-1 do begin
	if strlen(scanfiles[i]) gt 0 then begin
		hds_open,scanfiles[i]
		get_bincounts,beam
		hds_close
		d=f[raw0:rawn]
	endif else d=f
	if classic then $
	delays[Raw0:RawN]=fringedelay(fringevis(bincounts[*,ch,*], $
				genconfig.fringemod[bl,ob]), $
				genconfig.wavelength[ch,ob], $
				d,fdlstamp(scan=0)/1000.d0,wrap=wrap) $
	else begin
	delays[Raw0:RawN]=fringedelay(fringevis(bincounts[*,ch,*], $
				genconfig.fringemod[bl,ob]), $
				genconfig.wavelength[ch,ob], $
				d,fdlstamp(scan=0)/1000.d0,index,wrap=wrap)
	gindex[raw0:rawn]=index
	endelse
endfor
;
return,delays
;
end
