function fringeframe,a,g,l,v,n,poisson=poisson,glas=glas,phase=phase
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Make standard NPOI 8 or 64-bin frames.
;
; Compute fringe frames for airpath a[mu] and group delay g[mu]. Optionally
; include visibility amplitude and photonrate (arrays). Wavelength array l[mu].
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
n1=n_elements(a)
n2=n_elements(g)
n3=n_elements(l)
n4=n_elements(v)
n5=n_elements(n)
;
if not keyword_set(poisson) then poisson=0
if n_elements(glas) eq 0 then glas=0.0
if n_elements(phase) eq 0 then phase=0.0
;
if n_elements(GenConfig) ne 0 then num_bin=GenConfig.NumBin else num_bin=8
;
cb=bytarr(num_bin,n3,n1)
cf=fltarr(num_bin,n3,n1)
;
if n4 eq 0 then v=fltarr(n1)+0.6
if n5 eq 0 then n=fltarr(n1)+40
if n4 eq 1 then v=fltarr(n1)+v[0]
if n5 eq 1 then n=fltarr(n1)+n[0]
;
nbin=3
num_phs=num_bin*nbin
m=((findgen(num_phs)-nbin/2)*2*!pi/num_phs)#(fltarr(n3)+1)
twopi=fltarr(num_phs)+2*!pi
n_1=edlen(l)-1
ns_1=silica(l)-1
for i=0l,n1-1 do begin
	d=twopi#((n_1*a[i]+g[i]+ns_1*glas)/l)
;	c(*,*,i)=byte(((1.0+v(i)*cos(m+d))*n(i)))
;	y=(1.0+v(i)*cos(m+d))*((n(i)/num_bin)/nbin)
;	for k=0,num_bin-1 do cf(k,*,i)=total(y(k*nbin:(k+1)*nbin-1,*),1)
	y=cos(m+d-phase)
	for k=0,num_bin-1 do cf[k,*,i]=total(y[k*nbin:(k+1)*nbin-1,*],1)/nbin
	cf[*,*,i]=(cf[*,*,i]*v[i]+1)*(n[i]/num_bin)
;	cf(*,*,i)=(add(1.0+v(i)*cos(m+d),nbin,0)/nbin)*n(i)
;	cf(*,*,i)=(1.0+v(i)*cos(m+d+phase))*n(i)
endfor
;
k=n_elements(cf)
if poisson then begin
	s=linknload(!external_lib,'randpoisson',cb,cf,k)
endif
;
if poisson then return,cb else return,cf
;
end
