pro fringeframes
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display a widget which lets one create and view fringe frames as a
; function of tracking delay and air path.
;
common FringeFramesLocal,a,g,n,v,s,d_wid
;
loadct,0
;
base_wid=widget_base(/column)
d_wid=widget_draw(base_wid,notify_realize='fringeframes_event', $
	event_pro='fringeframes_event', $
	scr_xsize=192+192,scr_ysize=128)
a_wid=cw_fslider(base_wid,minimum=-30,maximum=30,value=0,/drag, $
	title='Differential air path [mm]', $
	uvalue='a',xsize=400)
g_wid=cw_fslider(base_wid,minimum=-10,maximum=10,value=0,/drag, $
	title='Tracking offset (FDL delay) [microns]', $
	uvalue='g',xsize=400)
s_wid=cw_fslider(base_wid,minimum=-50,maximum=50,value=0,/drag, $
	title='Glas mismatch [mu]', $
	uvalue='s',xsize=400)
v_wid=cw_fslider(base_wid,minimum=0.3,maximum=1.0,value=1,/drag, $
	title='Visibility amplitude', $
	uvalue='v',xsize=400)
n_wid=cw_fslider(base_wid,minimum=40,maximum=800,value=800,/drag, $
	title='Photonrate', $
	uvalue='n',xsize=400)
widget_control,base_wid,/realize
xmanager,'fringetrack',base_wid,/no_block,event_handler='fringeframes_event'
;
end
