pro fringeframes_event,event
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common FringeFramesLocal,a,g,n,v,s,d_wid
;
l=1/poly(findgen(32),[1.21678,0.034929])
r=poly_fit(l,edlen(l)-1,1)
;
nx=64
ny=64
;
result=size(event)
if result[n_elements(result)-2] ne 8 then begin
	a=0
	s=0
	g=0
	n=40
	v=1.0
endif else begin
	widget_control,event.id,get_uvalue=slider,get_value=value
	case slider of
		'a':a=value*1000
		's':s=value
		'g':g=value
		'v':v=value
		'n':n=fix(value/8)
	endcase
endelse
;
frame1=fringeframe(a,g,l,v,n,/poisson,glas=s)
n_bin=n_elements(frame1[*,0])
n_chn=n_elements(frame1[0,*])
x=float(long(findgen(nx)/nx*n_bin))
y=float(long(findgen(ny)/ny*n_chn))
vis=fringevis(frame1)
d=gitter(121,-12.)
fp=visdft(vis,l,d)
gd=groupdelay(fp,l,d)
gp=cphase(visdft(vis,l,gd))
ds=phaseshift(g/1e6,l/1e6)*(avg(l)/(2*!pi))
;solve,visrotate(vis,l,gd),l/1e6,sol1,/plot
;solve,vis,l/1e6,sol1,/plot
solve,vis,l/1e6,sol1
;
!p.charsize=1.0
widget_control,d_wid,get_value=id
wset,id
;
; Display raw frame
tvscl,interpolate(shift(reform(frame1),n_bin/2,0),x,y,/grid)
tv,bytarr(64,64),0,64
xyouts,0,80,/device,'g ='+string(gd,format='(f5.2)')
xyouts,0,70,/device,'p ='+string(cphase(total(visrotate(vis,l,gd)))*180/!pi, $
	format='(f6.1)')
;
; Display rotated frame
frame2=rotateframe(frame1,l,gd[0])
tvscl,interpolate(shift(reform(frame2),4,0),x,y,/grid),64,0
tv,bytarr(64,64),64,64
xyouts,64,70,/device,'P ='+string(-ds/avg(l)*360,format='(f6.1)')
;
; Display dispersion corrected frame
;tvscl,interpolate(shift(reform(frame3),4,0),x,y,/grid),128,0
tv,bytarr(64,64),128,64
xyouts,128,90,/device,'n ='+string(fix(sol1[2]),format='(i6)')
xyouts,128,80,/device,'v ='+string(sol1[0],format='(f6.1)')
xyouts,128,70,/device,'D ='+string(g+sol1[0],format='(f6.1)')
;
tv,bytarr(64,64),192,64
xyouts,192,120,/device,'g = group delay [mu]'
xyouts,192,110,/device,'p = phase of tracked fringe [deg]'
xyouts,192,100,/device,'P = phase shift from FDL delay [deg]'
xyouts,192, 90,/device,'n = fringe ID'
xyouts,192, 80,/device,'v = vacuum delay [mu]'
xyouts,192, 70,/device,'D = geometric delay [mu] (=0)'
;
end
